import http from '@/http-common'
const API_URL = '/api/v1/raider'

class RaiderService {
  getRaiders (accountId) {
    return http.get(`${API_URL}/me`)
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error fetching raiders:', error)
        throw error
      })
  }

  getRaider (id) {
    return http.get(`${API_URL}/by_id/${id}`)
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error fetching raider:', error)
        throw error
      })
  }

  createRaider (raiderData) {
    return http.post(`${API_URL}/`, raiderData)
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error creating raider:', error)
        throw error
      })
  }

  updateRaider (id, raiderData) {
    return http.patch(`${API_URL}/${id}`, raiderData)
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error updating raider:', error)
        throw error
      })
  }

  deleteRaider (id) {
    return http.delete(`${API_URL}/${id}`)
      .then(res => {
        return res.data
      })
      .catch(error => {
        console.error('Error deleting raider:', error)
        throw error
      })
  }
}

export default new RaiderService()
