import http from '../http-common'

class ServiceServices {
  getAll () {
    return http.get('/api/v1/service/all')
  }

  getAllMyServices () {
    const token = localStorage.getItem('token')
    return http.get(`/api/v1/service/me`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then((res) => res.data)
      .catch((error) => {
        console.error('Error al obtener los servicios del usuario:', error.response?.data || error.message)
        throw error
      })
  }

  getAllServicesByAccountId (accountId) {
    const token = localStorage.getItem('token')
    return http.get(`/api/v1/service/by_account/${accountId}`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then((res) => res.data)
      .catch((error) => {
        console.error('Error al obtener los servicios del usuario:', error.response?.data || error.message)
        throw error
      })
  }

  get (id) {
    return http.get(`/api/v1/service/by_id/${id}`)
  }

  create (data) {
    return http.post('/api/v1/service', data)
  }

  update (id, data) {
    return http.put(`/api/v1/service/${id}`, data)
  }

  delete (serviceType, id) {
    if (serviceType === 'espai') {
      return http.delete(`/api/v1/espai/${id}`)
    } else if (serviceType === 'catering') {
      return http.delete(`/api/v1/catering/${id}`)
    } else if (serviceType === 'decoracio' || serviceType === 'mobiliari') {
      return http.delete(`/api/v1/mobiliari-decoracio/${id}`)
    } else if (serviceType === 'musica') {
      return http.delete(`/api/v1/musica/${id}`)
    } else if (serviceType === 'fotografia') {
      return http.delete(`/api/v1/fotografia/${id}`)
    }
  }

  getServicesByRaider (raiderId) {
    const token = localStorage.getItem('token')
    return http.get(`/api/v1/service/by_raider/${raiderId}`, {
      headers: {
        'Authorization': `Bearer ${token}`
      }
    })
      .then((res) => res.data)
      .catch((error) => {
        console.error('Error al obtener los servicios del raider:', error.response?.data || error.message)
        throw error
      })
  }

  // Métodos específicos por tipo de servicio
  getCateringServices () {
    return http.get('/services?type=catering')
  }

  getDecoracionServices () {
    return http.get('/services?type=mobiliari-decoracio')
  }

  getMusicaServices () {
    return http.get('/services?type=musica')
  }

  getFotografiaServices () {
    return http.get('/services?type=fotografia')
  }

  getEspaisServices () {
    return http.get('/services?type=espai')
  }

  // Métodos de filtrado
  filterServices (params) {
    return http.get('/services/filter', { params })
  }
}

export default new ServiceServices()
