// Servicio para subir imágenes al backend (que las sube a S3)
import http from '../http-common'

const API_URL = '/api/v1/upload/upload-image/'

const UploadServices = {
  async uploadImage (file) {
    const formData = new FormData()
    formData.append('file', file)
    // Usamos http.post para aprovechar interceptores y baseURL
    const response = await http.post(API_URL, formData, {
      headers: {
        'Content-Type': 'multipart/form-data'
      }
    })
    return response.data.url
  }
}

export default UploadServices
