# scripts/script4_map_recomendaciones.py

# Cada key puede ser literal (startswith) o regex (usando re.search)
MAPPING = {
    # Linux: auditor de permisos
    "UID duplicado:": {
        "codigo_ens": "Op.acc.2",
        "titulo": "UID duplicado en Linux",
        "descripcion": (
            "Se ha detectado un UID duplicado en el sistema. ENS Nivel Alto (Op.acc.2) requiere que cada usuario "
            "tenga un identificador único para garantizar trazabilidad.\n"
            "Recomendamos:\n"
            "  • Revisar /etc/passwd y corregir los UIDs duplicados.\n"
            "  • Validar que cada usuario use un UID distinto.\n"
            "  • Comprobar que no existan inconsistencias en los permisos derivados."
        ),
        "referencia": "Op.acc.2 (Requisitos de Acceso)"
    },
    "Usuario con shell sospechosa:": {
        "codigo_ens": "Op.acc.2",
        "titulo": "Usuario con shell inusual en Linux",
        "descripcion": (
            "Se ha detectado que un usuario tiene una shell sospechosa (no interactiva). ENS Op.acc.2 recomienda "
            "que solo cuentas legítimas dispongan de shells de login válidas.\n"
            "Recomendamos:\n"
            "  • Verificar si realmente necesita shell.\n"
            "  • Cambiar shell a /usr/sbin/nologin o /bin/false si no es necesaria.\n"
            "  • Revisar permisos de esa cuenta para descartar accesos no autorizados."
        ),
        "referencia": "Op.acc.2 (Requisitos de Acceso)"
    },
    # Windows y Linux: gestión de privilegios y cuentas
    "Usuario con privilegios": {
        "codigo_ens": "Op.acc.4",
        "titulo": "Cuentas en grupos privilegiados",
        "descripcion": (
            "Se ha detectado que el usuario '{usuario}' pertenece a un grupo de administradores. "
            "ENS Nivel Alto (Op.acc.4) exige que las cuentas privilegiadas estén justificadas y documentadas.\n"
            "Recomendamos:\n"
            "  • Confirmar si '{usuario}' necesita realmente permisos de administrador.\n"
            "  • Revocar permisos si no son imprescindibles.\n"
            "  • Documentar en un registro interno las cuentas con privilegios.\n"
            "  • Aplicar MFA/2FA a todas las cuentas administrativas."
        ),
        "referencia": "Op.acc.4 (Gestión de Derechos de Acceso)"
    },
    "Cuenta bloqueada:": {
        "codigo_ens": "Op.acc.5",
        "titulo": "Cuenta bloqueada en Linux",
        "descripcion": (
            "Se ha detectado una cuenta bloqueada. ENS Op.acc.5 exige bloqueos automáticos tras X fallos "
            "y un procedimiento de desbloqueo formal.\n"
            "Recomendamos:\n"
            "  • Verificar la causa del bloqueo.\n"
            "  • Configurar pam_tally2 o faillog para bloqueos tras 5 fallos.\n"
            "  • Documentar quién y cuándo desbloquea cuentas."
        ),
        "referencia": "Op.acc.5 (Mecanismos de Autenticación)"
    },
    "Usuario expirado:": {
        "codigo_ens": "Op.acc.6",
        "titulo": "Usuario expirado en Linux",
        "descripcion": (
            "Se ha detectado un usuario con cuenta expirada. ENS Op.acc.6 indica que las cuentas inactivas "
            "deben revisarse o eliminarse.\n"
            "Recomendamos:\n"
            "  • Confirmar si el usuario sigue en uso; si no, eliminarlo.\n"
            "  • Reactivar correctamente si debe mantenerse.\n"
            "  • Programar revisiones periódicas de cuentas inactivas."
        ),
        "referencia": "Op.acc.6 (Mecanismos de Autenticación Internos)"
    },
    # Parámetros de política de contraseña en Linux
    "Usuario con contraseña que nunca expira": {
        "codigo_ens": "Op.acc.6",
        "titulo": "Cuenta sin expiración de contraseña",
        "descripcion": (
            "Se ha detectado que el usuario '{usuario}' tiene la contraseña configurada para que nunca expire. "
            "ENS Nivel Alto (Op.acc.6) requiere expiración periódica.\n"
            "Recomendamos:\n"
            "  • Establecer PASS_MAX_DAYS ≥ 90 en /etc/login.defs.\n"
            "  • Forzar cambio de contraseña en próximo inicio.\n"
            "  • Revisar periódicamente las cuentas sin expiración."
        ),
        "referencia": "Op.acc.6 (Mecanismos de Autenticación Internos)"
    },
    r"PASS_MAX_DAYS": {
        "codigo_ens": "Op.acc.6",
        "titulo": "Periodo de expiración de contraseña incorrecto",
        "descripcion": (
            "PASS_MAX_DAYS difiere de 90. ENS Op.acc.6 exige un periodo ≥ 90 días.\n"
            "Recomendamos:\n"
            "  • Ajustar PASS_MAX_DAYS a 90.\n"
            "  • Verificar PASS_MIN_DAYS e INTENTOS_FALLIDOS."
        ),
        "referencia": "Op.acc.6 (Mecanismos de Autenticación Internos)"
    },
    r"PASS_MIN_DAYS": {
        "codigo_ens": "Op.acc.6",
        "titulo": "Cadencia mínima de cambio de contraseña inadecuada",
        "descripcion": (
            "PASS_MIN_DAYS es 0. ENS Op.acc.6 recomienda ≥ 1 día para evitar cambios rápidos.\n"
            "Recomendamos:\n"
            "  • Ajustar PASS_MIN_DAYS a 1."
        ),
        "referencia": "Op.acc.6 (Mecanismos de Autenticación Internos)"
    },
    r"INTENTOS_FALLIDOS": {
        "codigo_ens": "Op.acc.5",
        "titulo": "No hay bloqueo tras intentos fallidos",
        "descripcion": (
            "INTENTOS_FALLIDOS está en 'Nunca'. ENS Op.acc.5 exige bloquear tras X fallos.\n"
            "Recomendamos:\n"
            "  • Configurar faillog/pam_tally2 para bloquear tras 5 fallos en 2 min."
        ),
        "referencia": "Op.acc.5 (Mecanismos de Autenticación Usuarios Externos)"
    },
}
