# scripts/script5_map_recomendaciones.py

MAPPING_5 = {
    "Windows_FuerzaBruta": {
        "titulo": "Fuerza Bruta Windows detectada",
        "descripcion": (
            "Se han registrado múltiples intentos fallidos de inicio de sesión en Windows "
            "(EventID 4625). Esto indica que alguien está intentando adivinar credenciales."
        ),
        "recomendacion": (
            "• Configura bloqueo de cuenta tras 3 fallos en 15 min (GPO: Account lockout threshold).\n"
            "• Monitorea el Event Viewer y bloquea IPs sospechosas en el firewall.\n"
            "• Habilita MFA para todas las cuentas críticas."
        ),
        "referencia": "Op.MON.2 (Monitorización y Gestión de Eventos)"
    },
    "Windows_FuerzaBrutaConExito": {
        "titulo": "Inicio tras fuerza bruta exitoso",
        "descripcion": (
            "Se ha detectado un inicio de sesión exitoso después de varios fallos (EventID 4624). "
            "Podría significar que un atacante ha logrado acceder."
        ),
        "recomendacion": (
            "• Cambia inmediatamente la contraseña de la cuenta afectada.\n"
            "• Revisa histórico de logons y busca movimientos laterales.\n"
            "• Habilita MFA y restringe accesos remotos innecesarios."
        ),
        "referencia": "Op.MON.2"
    },
    "Windows_CreacionCuenta": {
        "titulo": "Creación de cuenta no autorizada",
        "descripcion": (
            "Se ha creado una cuenta local en Windows (EventID 4720). Esto debe estar siempre "
            "autorizado y registrado."
        ),
        "recomendacion": (
            "• Verifica que la creación estaba autorizada; si no, elimina la cuenta.\n"
            "• Documenta en un ticket interno la justificación.\n"
            "• Configura alertas automáticas en tu SIEM/EDR."
        ),
        "referencia": "Op.MON.1 / Op.MON.3"
    },
    "Windows_HabilitacionCuenta": {
        "titulo": "Habilitación de cuenta local",
        "descripcion": (
            "Una cuenta local ha sido habilitada (EventID 4722). Cualquier cambio de estado "
            "debe quedar registrado."
        ),
        "recomendacion": (
            "• Comprueba que la habilitación está justificada.\n"
            "• Documenta quién y por qué motivo se hizo el cambio.\n"
            "• Revisa periódicamente cuentas habilitadas."
        ),
        "referencia": "Op.MON.3"
    },
    "Linux_InvalidUser": {
        "titulo": "Intento SSH con usuario inválido",
        "descripcion": (
            "Se ha recibido un intento de autenticación SSH con un usuario que no existe. "
            "Puede ser un escaneo de diccionario."
        ),
        "recomendacion": (
            "• Asegura `PermitRootLogin no` y restringe acceso por contraseña.\n"
            "• Instala y configura fail2ban para bloquear IPs tras X fallos.\n"
            "• Revisa `/etc/ssh/sshd_config` para endurecer políticas."
        ),
        "referencia": "Op.MON.2"
    },
    "Linux_FuerzaBrutaSSH": {
        "titulo": "Fuerza Bruta SSH detectada",
        "descripcion": (
            "Múltiples fallos de autenticación SSH en corto periodo. Es un claro indicio de fuerza bruta."
        ),
        "recomendacion": (
            "• Implementa fail2ban o similar para bloquear tras 5 fallos en 2 min.\n"
            "• Deshabilita login por contraseña y usa claves SSH.\n"
            "• Monitorea intentos y bloquea IP sospechosas."
        ),
        "referencia": "Op.MON.2"
    },
    "Linux_FuerzaBrutaConExitoSSH": {
        "titulo": "Inicio SSH tras fuerza bruta",
        "descripcion": (
            "Se ha autenticado con éxito tras varios fallos. Podría significar credenciales comprometidas."
        ),
        "recomendacion": (
            "• Cambia la clave del usuario afectado inmediatamente.\n"
            "• Revisa `/var/log/auth.log` para movimientos post-login.\n"
            "• Refuerza políticas de autenticación (claves, MFA)."
        ),
        "referencia": "Op.MON.2"
    },
    "Linux_FileModificado": {
        "titulo": "Archivo crítico modificado",
        "descripcion": (
            "Se ha detectado un cambio en un fichero sensible (passwd, shadow, sshd_config)."
        ),
        "recomendacion": (
            "• Restaura desde backup y revisa quién hizo el cambio (auditd).\n"
            "• Asegura integridad de ficheros con tripwire o AIDE.\n"
            "• Revisa políticas de despliegue y control de cambios."
        ),
        "referencia": "Op.MON.3"
    },
    "Windows_Firewall_DROP": {
        "titulo": "Firewall Windows bloqueó tráfico",
        "descripcion": (
            "El firewall ha bloqueado un intento de conexión (EventID 5152). Puede ser legítimo o malicioso."
        ),
        "recomendacion": (
            "• Verifica si el puerto bloqueado debería estar abierto.\n"
            "• Documenta reglas de firewall en inventario.\n"
            "• Configura alertas para bloqueos en puertos críticos."
        ),
        "referencia": "Mp.SI.2"
    },
    "Windows_Firewall_ALLOW": {
        "titulo": "Firewall Windows permitió tráfico",
        "descripcion": (
            "El firewall ha dejado pasar tráfico en un puerto (EventID 5156). Puede exponer servicios."
        ),
        "recomendacion": (
            "• Audita puertos abiertos y cierra los innecesarios.\n"
            "• Documenta servicios expuestos y aplica el principio de mínimo privilegio.\n"
            "• Revisa procesos asociados a esos puertos."
        ),
        "referencia": "Mp.SI.2"
    },
}
