# scripts/script6_map_recomendaciones.py

MAPPING_6 = {
    "tcp_abiertos": {
        "titulo": "Puertos TCP abiertos",
        "descripcion": "Puerto(s) TCP que respondieron con un SYN-ACK tras el escaneo.",
        "recomendacion": (
            "Puertos TCP abiertos: {value}. Si alguno no es necesario, bloquéalo en el\n"
            "firewall (iptables/UFW) o ciérralo en el servidor. Para HTTP/HTTPS (80/443),\n"
            "asegúrate de aplicar TLS y mantener certificados actualizados."
        ),
        "referencia": "Op.acc.2 (Requisitos de Acceso)"
    },
    "udp_abiertos": {
        "titulo": "Puertos UDP abiertos/filtrados",
        "descripcion": "Puerto(s) UDP que no devolvieron ICMP de “puerto inalcanzable”,\npueden estar abiertos o filtrados.",
        "recomendacion": (
            "Puertos UDP abiertos/filtrados: {value}. Verifica si esos servicios (DNS, SNMP,\n"
            "DHCP) deben ser accesibles; de lo contrario, añádelos a las reglas de bloqueo.\n"
        ),
        "referencia": "Op.acc.2"
    },
    "ftp_anonimo": {
        "titulo": "FTP con acceso anónimo",
        "descripcion": "Indica si el servicio FTP permite login anónimo.",
        "recomendacion": (
            "{value_text}"
        ),
        "referencia": "Mp.si.3 (Protección de Servicios)"
    },
    "telnet_banner": {
        "titulo": "Servicio Telnet",
        "descripcion": "Banner de Telnet si existe; null indica que no hay servicio Telnet.",
        "recomendacion": "{value_text}",
        "referencia": "Op.acc.2"
    },
    "http_banner": {
        "titulo": "Servicio HTTP",
        "descripcion": "Banner HTTP si existe; null indica que no hay servicio HTTP.",
        "recomendacion": "{value_text}",
        "referencia": "Op.acc.2"
    },
    "icmp_enviados": {
        "titulo": "Prueba ICMP (flood ligero)",
        "descripcion": "Número de paquetes ICMP enviados para prueba de conectividad.",
        "recomendacion": (
            "Se enviaron {value} paquetes ICMP. Esto es normal para pruebas internas,\n"
            "pero considera filtrar ICMP en ambientes de producción para reducir superficie\n"
            "de detección de topología de red."
        ),
        "referencia": "Op.mon.2 (Monitorización de Red)"
    },
    "snmp_info": {
        "titulo": "Información SNMP",
        "descripcion": "Datos recibidos del servicio SNMP (puerto 161), o null si no responde.",
        "recomendacion": "{value_text}",
        "referencia": "Mp.si.2"
    }
}
