Detector ENS (Script 5) – Guía para PYMEs
Este documento detalla cómo descargar, instalar y usar el Detector de Incidentes ENS en tu entorno (Windows o Linux), y cómo subir el resultado a nuestro portal web para obtener un informe automático con recomendaciones claras.

1. Introducción
El Script 5 (“Detector de Incidentes ENS”) monitoriza en tiempo real eventos de seguridad críticos (fuerza bruta de contraseñas, creación o habilitación de cuentas, elevación de privilegios, cambios sospechosos en archivos críticos, bloqueos/permisos de firewall, etc.) y los registra en un fichero de alertas. Después, podrás subir ese fichero a nuestra web para recibir:

Un resumen estadístico de todas las alertas.

Una tabla detallada con cada alerta (timestamp, tipo, usuario/origen, mensaje).

Gráficos sencillos (alertas por tipo y por hora/día).

Recomendaciones automáticas para cada tipo de alerta.

De este modo tendrás una foto clara de tu postura de seguridad y sabrás qué acciones tomar para cumplir los requisitos del ENS Nivel Alto, particularmente los controles de monitoreo y detección de anomalías (OP.MON).

2. Requisitos Previos
Sistema Operativo

Windows 10/11 64-bit (PowerShell 5.1+).

Linux (Ubuntu 20.04+, Debian 10+, CentOS 7+ u otro similar).

Cuenta con privilegios

En Windows, una cuenta con permisos de administrador.

En Linux, un usuario con permisos sudo o root.

Python 3.8+ instalado

Comprueba con:

bash
Copiar
Editar
# Linux
python3 --version

# Windows PowerShell
python --version
Si no tienes Python 3, instálalo:

En Windows: descarga el instalador desde python.org y sigue las instrucciones.

En Linux (Debian/Ubuntu):

bash
Copiar
Editar
sudo apt update
sudo apt install python3 python3-venv python3-pip -y
PIP

Viene con Python 3.8+.

Verifica con:

bash
Copiar
Editar
pip --version
(Opcional para producción) Logstash + Beats

Si quieres alimentar al Detector con eventos reales de tu sistema (Windows Event Log o Linux syslog), instala:

Windows: Winlogbeat

Linux: Filebeat

Y configura un pipeline mínimo de Logstash para leer de esos Beats y volcar JSON a un archivo.

Permisos de escritura/lectura

El Detector lee un fichero JSON (de Logstash/Beats) y escribe alertas en un fichero .log.

Asegúrate de que tu usuario tenga permisos para:

Crear/leer/escribir /var/log/incidentes.json y /var/log/incidentes_alertas.log en Linux.

Crear/leer/escribir C:\logs\incidentes.json y C:\logs\incidentes_alertas.log en Windows.

3. Descarga del Script y Contenido del ZIP
Entra en nuestro portal web (por ejemplo, https://tusitio.com/detector-incidentes).

Haz clic en “Descargar Detector ENS (Script 5)” y guarda el ZIP (p. ej. detector_ens.zip).

Descomprímelo en tu carpeta local. Deberías ver esta estructura:

bash
Copiar
Editar
detector_ens/
├── detector_unificado.py
├── requirements.txt
├── ejemplo_logstash.conf       # Opcional, para quien use Logstash
└── README_PYME.md              # Este documento
4. Instalación de Dependencias
Tanto si usas Windows como Linux, te recomendamos crear un entorno virtual de Python para separar dependencias.

4.1. Crear entorno virtual (opcional pero recomendado)
Windows (PowerShell):

powershell
Copiar
Editar
cd C:\ruta\a\detector_ens
python -m venv venv_detector
.\venv_detector\Scripts\Activate.ps1
Linux (bash):

bash
Copiar
Editar
cd ~/ruta/a/detector_ens
python3 -m venv venv_detector
source venv_detector/bin/activate
4.2. Instalar dependencias
Dentro del entorno virtual (o en tu Python global si no usas virtualenv), ejecuta:

bash
Copiar
Editar
pip install --upgrade pip
pip install -r requirements.txt
requirements.txt incluye colorama (para colores en consola) y cualquier otra librería que detector_unificado.py necesite.

5. Configurar Rutas de Log y Permisos
El Detector, por defecto, usa estas rutas en Linux:

Fichero de entrada JSON: /var/log/incidentes.json
(aquí Logstash ó Filebeat deja eventos en formato JSON, uno por línea).

Fichero de alertas generado: /var/log/incidentes_alertas.log
(aquí el Detector escribe cada alerta como línea de texto).

5.1. En Linux
Crea los archivos y ajusta permisos:

bash
Copiar
Editar
sudo touch /var/log/incidentes.json /var/log/incidentes_alertas.log
sudo chown $(whoami):$(whoami) /var/log/incidentes.json /var/log/incidentes_alertas.log
chmod 664 /var/log/incidentes.json /var/log/incidentes_alertas.log
Asegúrate de que tu usuario puede leer /var/log/incidentes.json (ese JSON lo genera Filebeat o Logstash) y escribir /var/log/incidentes_alertas.log.

5.2. En Windows
Si prefieres usar Windows, modifica detector_unificado.py para apuntar a rutas Windows. Abre el script y busca:

python
Copiar
Editar
INCIDENTS_JSON      = "/var/log/incidentes.json"
ALERTS_LOG          = "/var/log/incidentes_alertas.log"
Cámbialo por algo como:

python
Copiar
Editar
INCIDENTS_JSON      = r"C:\logs\incidentes.json"
ALERTS_LOG          = r"C:\logs\incidentes_alertas.log"
Luego:

Crea la carpeta y los archivos:

powershell
Copiar
Editar
New-Item -ItemType Directory -Path "C:\logs" -Force
New-Item -ItemType File -Path "C:\logs\incidentes.json" -Force
New-Item -ItemType File -Path "C:\logs\incidentes_alertas.log" -Force
Asegúrate de ejecutar PowerShell como administrador al modificar los archivos de C:\logs y al ejecutar el Detector.

6. (Opcional) Configuración de Beats y Logstash
Si quieres que tu Detector reciba eventos en tiempo real del sistema, debes poner en marcha un pipeline que envíe los events a un JSON con cada línea. A continuación tienes instrucciones mínimas tanto para Windows (Winlogbeat) como para Linux (Filebeat), y la opción de usar Logstash para filtrar/normalizar.

6.1. Windows – Winlogbeat + Logstash (opcional)
1. Descarga Winlogbeat

Descarga Winlogbeat y descomprime el ZIP, por ejemplo, en C:\Program Files\Winlogbeat.

2. Edita winlogbeat.yml
Busca estas secciones y modifícalas para que los eventos Security vayan a un fichero JSON (C:\logs\incidentes.json):

yaml
Copiar
Editar
winlogbeat.event_logs:
  - name: Security
    ignore_older: 12h

#-----------------------------------------------------------
# Configuración de output (salida) a fichero JSON:
#-----------------------------------------------------------
output.file:
  path: "C:/logs"
  filename: "incidentes"
  rotate_every_kb: 10000
  number_of_files: 7
Con esto, Winlogbeat escribirá en C:\logs\incidentes.json cada evento de Security en formato JSON, uno por línea.

3. Instala y arranca Winlogbeat como servicio
Abre PowerShell como Administrador:

powershell
Copiar
Editar
cd "C:\Program Files\Winlogbeat"
.\install-service-winlogbeat.ps1
Start-Service winlogbeat
Comprueba que se está escribiendo JSON en C:\logs\incidentes.json.

4. (Opcional) Añadir Logstash de por medio
Si quieres filtrar o enriquecer esos JSON, crea un pipeline mínimo en Logstash:

Crea un archivo logstash.conf con este contenido (ajusta rutas a Windows o a Linux según donde lo ejecutes):

lua
Copiar
Editar
input {
  file {
    path => ["C:/logs/incidentes.json"]
    codec => "json"
    start_position => "beginning"
    sincedb_path => "NUL"
  }
}

filter {
  # Aquí podemos hacer grok, filtrar campos innecesarios, renombrar, etc.
}

output {
  file {
    path => "C:/logs/incidentes_normalizado.json"
    codec => "json_lines"
  }
}
Ejecuta Logstash (desde PowerShell como Administrador):

powershell
Copiar
Editar
"C:\Program Files\Logstash\bin\logstash.bat" -f "C:\ruta\a\logstash.conf"
Luego cambia en detector_unificado.py:

python
Copiar
Editar
INCIDENTS_JSON = r"C:\logs\incidentes_normalizado.json"
ALERTS_LOG     = r"C:\logs\incidentes_alertas.log"
6.2. Linux – Filebeat + Logstash (opcional)
1. Instalar Filebeat (Debian/Ubuntu)

bash
Copiar
Editar
sudo apt update
sudo apt install filebeat -y
2. Editar /etc/filebeat/filebeat.yml
Añade un input para leer /var/log/auth.log y /var/log/syslog (u otro log que te interese), y que la salida vaya a un JSON:

yaml
Copiar
Editar
filebeat.inputs:
  - type: log
    enabled: true
    paths:
      - /var/log/auth.log
      - /var/log/syslog
    json.keys_under_root: true
    json.add_error_key: true

output.file:
  path: "/var/log"
  filename: "incidentes"
  rotate_every_kb: 10000
  number_of_files: 7
Con eso, Filebeat escribirá en /var/log/incidentes.json, cada línea ya en JSON.

3. Arrancar Filebeat

bash
Copiar
Editar
sudo systemctl enable filebeat
sudo systemctl start filebeat
4. (Opcional) Añadir Logstash de por medio
Si prefieres procesar o filtrar esos JSON, crea un pipeline mínimo en Logstash:

Crea /etc/logstash/conf.d/ens.conf con algo así:

lua
Copiar
Editar
input {
  file {
    path => [ "/var/log/incidentes.json" ]
    codec => "json"
    start_position => "beginning"
    sincedb_path => "/dev/null"
  }
}

filter {
  # Aquí puedes añadir grok, mutates, etc.
}

output {
  file {
    path => "/var/log/incidentes_normalizado.json"
    codec => "json_lines"
  }
}
Arranca Logstash:

bash
Copiar
Editar
sudo /usr/share/logstash/bin/logstash -f /etc/logstash/conf.d/ens.conf
Modifica detector_unificado.py:

python
Copiar
Editar
INCIDENTS_JSON = "/var/log/incidentes_normalizado.json"
ALERTS_LOG     = "/var/log/incidentes_alertas.log"
7. Ejecución del Detector
Con los Beats/Logstash en marcha (o sin ellos, si vas a simular eventos manualmente), ya puedes arrancar el detector:

Abre una terminal (PowerShell/admin en Windows o bash en Linux).

Activa el entorno virtual (si lo creaste):

Windows PowerShell:

powershell
Copiar
Editar
cd C:\ruta\a\detector_ens
.\venv_detector\Scripts\Activate.ps1
Linux:

bash
Copiar
Editar
cd ~/ruta/a/detector_ens
source venv_detector/bin/activate
Ejecuta el Detector con permisos (necesita leer/escribir en las rutas de log):

Windows PowerShell (ejecutar como Administrador):

powershell
Copiar
Editar
python detector_unificado.py
Linux (ejecutar con sudo):

bash
Copiar
Editar
sudo python3 detector_unificado.py
Aparecerá en pantalla algo como:

java
Copiar
Editar
[*] Iniciando Detector Unificado (JSON)…
Pulsa Ctrl+C para detener.

[ALERTA] [2025-06-04 12:35:10] 5 fallos de logon Windows para usuario 'Admin' desde 192.168.1.10 en 2 minutos → POSIBLE FUERZA BRUTA (4625)

{
  "tipo": "Windows_FuerzaBruta",
  "event_id": 4625,
  "usuario": "Admin",
  "origen": "192.168.1.10",
  "num_fallos": 5,
  "ventana_min": 2,
  "timestamp": "2025-06-04 12:35:10"
}

[ALERTA] [2025-06-04 12:40:22] Cuenta local Windows 'pruebaUser' habilitada → REVISA si debe ser admin (4722).

{
  "tipo": "Windows_HabilitacionCuenta",
  "event_id": 4722,
  "usuario": "pruebaUser",
  "timestamp": "2025-06-04 12:40:22"
}
  …
Cada alerta se imprime en rojo por pantalla y, además, el Detector la graba en el fichero de log de alertas:

Linux: /var/log/incidentes_alertas.log

Windows: C:\logs\incidentes_alertas.log

Dentro de ese fichero verás líneas como:

vbnet
Copiar
Editar
[2025-06-04 12:35:10] 5 fallos de logon Windows para usuario 'Admin' desde 192.168.1.10 en 2 minutos → POSIBLE FUERZA BRUTA (4625)
[2025-06-04 12:40:22] Cuenta local Windows 'pruebaUser' habilitada → REVISA si debe ser admin (4722)
[2025-06-04 12:43:55] Intento SSH con usuario inválido 'ghost' desde 127.0.0.1 detectado en Linux.
[2025-06-04 12:50:01] 5 fallos de autenticación SSH Linux para usuario 'ghost' desde 127.0.0.1 en 2 minutos → POSIBLE FUERZA BRUTA SSH
El Detector seguirá corriendo hasta que lo detengas con Ctrl +C.

8. Probar con un Evento Simulado
Para asegurarte de que todo funciona correctamente, genera algún evento de prueba en paralelo:

8.1. En Windows
Abre PowerShell como Administrador.

Crea un usuario de prueba y añádelo al grupo Administradores:

powershell
Copiar
Editar
net user pruebaENS P@ssw0rd! /add
net localgroup Administradores pruebaENS /add
En Winlogbeat (o Logstash) verás que el EventID 4720 y 4728 se vuelcan a incidentes.json.

En la ventana donde corre el Detector, verás algo como:

csharp
Copiar
Editar
[ALERTA] [2025-06-04 12:40:22] Cuenta local Windows 'pruebaENS' habilitada → REVISA si debe ser admin (4722).

{
  "tipo": "Windows_HabilitacionCuenta",
  "event_id": 4722,
  "usuario": "pruebaENS",
  "timestamp": "2025-06-04 12:40:22"
}
En /var/log/incidentes_alertas.log (o C:\logs\incidentes_alertas.log) aparecerá la misma alerta.

8.2. En Linux
Abre un segundo terminal sin virtualenv activado (o uno diferente).

Genera varios intentos SSH fallidos contra localhost:

bash
Copiar
Editar
for i in {1..5}; do ssh usuario_inexistente@localhost echo ok; done
Al quinto intento, el Detector mostrará:

csharp
Copiar
Editar
[ALERTA] [2025-06-04 12:50:01] 5 fallos de autenticación SSH Linux para usuario 'usuario_inexistente' desde 127.0.0.1 en 2 minutos → POSIBLE FUERZA BRUTA SSH

{
  "tipo": "Linux_FuerzaBrutaSSH",
  "usuario": "usuario_inexistente",
  "origen": "127.0.0.1",
  "num_fallos": 5,
  "ventana_min": 2,
  "timestamp": "2025-06-04 12:50:01"
}
Esa misma alerta quedará en /var/log/incidentes_alertas.log.

Ahora ya sabes que tu Detector está capturando eventos reales y los guarda en el log de alertas.

9. Recolección y Subida de Logs a la Web
Cuando lleves un rato generando alertas (o quieras revisar el estado actual):

Detén el Detector presionando Ctrl +C en la terminal donde lo ejecutaste.

Localiza el fichero de alertas generado:

Linux: /var/log/incidentes_alertas.log

Windows: C:\logs\incidentes_alertas.log

Copia ese fichero a tu PC local (si estás en Linux, puedes abrir un gestor de archivos o usar scp).

Abre tu navegador y ve a la sección de la web:

arduino
Copiar
Editar
https://tusitio.com/subir-alertas
Dentro encontrarás un formulario que dice “Selecciona tu fichero de alertas (.log o .json) → [Subir]”.

Selecciona el archivo (por ejemplo incidentes_alertas.log) y pulsa Subir.

En unos segundos, la página te mostrará:

Total de alertas recibidas.

Número de incidentes por tipo (por ejemplo, “Windows_FuerzaBruta: 2”, “Linux_InvalidUser: 3”).

Tabla detallada: cada alerta con columnas:

Timestamp

Tipo (campo "tipo" en el JSON)

Mensaje / Detalle breve

Usuario / Origen

Gráficos sencillos (opcional) que te indiquen:

Alertas por tipo (barras).

Alertas por hora/día (para ver si hay picos de actividad).

Recomendaciones generales, según los tipos detectados. Ejemplos:

Windows_FuerzaBruta: “Revisar contraseñas, activar bloqueo tras 3 intentos, instalar o configurar Windows Defender para bloquear IPs sospechosas.”

Linux_InvalidUser: “Revisar /etc/ssh/sshd_config para deshabilitar PermitRootLogin no, configurar fail2ban para bloquear intentos, etc.”

Si tu portal lo permite, tendrás un botón “Descargar informe en PDF” para guardar una copia estática.

10. Interpretación del Informe y Siguientes Pasos
La idea es que, tras visualizar el informe, la PYME obtenga información acciónable:

Para cada tipo de alerta (por ejemplo, Windows_FuerzaBruta), se mostrarán todas las ocurrencias y una breve recomendación:

“Se detectaron 5 intentos fallidos de inicio de sesión para ‘Admin’ desde 192.168.1.10. ENS Alto (OP.MON.2) exige bloquear tras X intentos. Recomendación: configurar bloqueo de cuenta tras 3 fallos, bloquear IP y revisar logs de seguridad.”

Para Windows_CreacionCuenta o Windows_HabilitacionCuenta:

“Se creó/ habilitó la cuenta ‘pruebaENS’ sin control previo. ENS Alto (OP.MON.1/OP.MON.3) exige trazabilidad de usuarios. Recomendación: confirmar si es válido, si no, eliminar o cambiar de contraseña.”

Para Linux_InvalidUser o Linux_FuerzaBrutaSSH:

“Se intentó acceso SSH con usuario inexistente ‘ghost’ desde 127.0.0.1. ENS Alto exige monitorizar fallos de autenticación. Recomendación: bloquear IP, deshabilitar login por contraseña en SSH y usar claves SSH.”

Para Linux_FileModificado:

“Se detectó cambio en /etc/shadow. ENS Alto (OP.MON.3) exige control de integridad de archivos. Recomendación: restaurar desde backup y revisar quién modificó el archivo. Asegurar permisos correctos.”

Para Windows_Firewall_DROP o Windows_Firewall_ALLOW:

“Se bloquearon/permitieron conexiones en puertos no habituales. ENS Alto recomienda revisar reglas de firewall, cerrar puertos no esenciales y asegurar que sólo servicios legítimos estén escuchando.”

11. FAQ (Preguntas Frecuentes)
¿Puedo ejecutar el Detector sin Logstash/Beats?
Sí. Si no hay JSON en /var/log/incidentes.json, el Detector esperará sin hacer nada. Puedes simular eventos manualmente (generando los JSON a mano o modificando el fichero) para probar.

¿El Detector consume muchos recursos?
No. Sólo hace un tail -f sobre un fichero de texto y parsea JSON. El consumo de CPU y RAM es mínimo (menos de 2‐3 MB de RAM, CPU casi despreciable).

¿Dónde se guardan los eventos antiguos?

/var/log/incidentes.json es gestionado por Beat/Logstash y crece indefinidamente, a menos que configures rotación (logrotate en Linux, rotación de Winlogbeat en Windows).

/var/log/incidentes_alertas.log contiene únicamente las alertas detectadas (un texto por evento), y también crecerá con el tiempo. Deberías configurar rotación de logs (por ejemplo, renombrar cada semana o usar logrotate).

¿Debo reiniciar el Detector cada vez que modifique algo?
Sí. Cada vez que cambies la configuración de Beats/Logstash o modifiques detector_unificado.py, detén el Detector con Ctrl +C y vuélvelo a arrancar para que recargue los cambios.

¿Dónde puedo pedir ayuda si algo falla?

Verifica primero que Python 3 esté correctamente instalado y tu PATH apunte a la versión 3.x.

Asegúrate de que /var/log/incidentes.json (o C:\logs\incidentes.json) existe y que tu usuario puede leerlo.

Asegúrate de que /var/log/incidentes_alertas.log (o C:\logs\incidentes_alertas.log) existe y tu usuario puede escribir en él.

Si continúa fallando, envíanos un correo a soporte@metodologia_ENS.com con capturas de pantalla del error y la salida completa de la consola.

12. Resumen de Comandos
12.1. Linux
bash
Copiar
Editar
# 1) Descargar y descomprimir (ejemplo con wget)
cd ~
wget https://tusitio.com/download/detector_ens.zip
unzip detector_ens.zip -d detector_ens
cd detector_ens

# 2) Crear entorno Python y activarlo
python3 -m venv venv_detector
source venv_detector/bin/activate

# 3) Instalar dependencias
pip install --upgrade pip
pip install -r requirements.txt

# 4) Crear logs en /var/log y dar permisos
sudo touch /var/log/incidentes.json /var/log/incidentes_alertas.log
sudo chown $(whoami):$(whoami) /var/log/incidentes.json /var/log/incidentes_alertas.log
chmod 664 /var/log/incidentes.json /var/log/incidentes_alertas.log

# 5) (Opcional) Instalar Filebeat y configurar para JSON
#    sudo apt install filebeat -y
#    editar /etc/filebeat/filebeat.yml tal y como se indica arriba
#    sudo systemctl enable filebeat && sudo systemctl start filebeat

# 6) (Opcional) Configurar Logstash
#    crear /etc/logstash/conf.d/ens.conf y luego:
#    sudo /usr/share/logstash/bin/logstash -f /etc/logstash/conf.d/ens.conf

# 7) Ejecutar Detector
sudo python3 detector_unificado.py

# 8) Cuando quieras informe, detener detector (Ctrl+C) y subir:
cat /var/log/incidentes_alertas.log   # este es el fichero que subes a la web
12.2. Windows (PowerShell)
powershell
Copiar
Editar
# 1) Descargar y descomprimir (ejemplo con Invoke-WebRequest)
cd C:\Users\TuUsuario\Descargas
Invoke-WebRequest -Uri "https://tusitio.com/download/detector_ens.zip" -OutFile "detector_ens.zip"
Expand-Archive -Path "detector_ens.zip" -DestinationPath "C:\Users\TuUsuario\detector_ens"
cd C:\Users\TuUsuario\detector_ens

# 2) Crear entorno Python (PowerShell)
python -m venv venv_detector
.\venv_detector\Scripts\Activate.ps1

# 3) Instalar dependencias
pip install --upgrade pip
pip install -r requirements.txt

# 4) Crear logs en C:\logs\ y dar permisos
New-Item -ItemType Directory -Path "C:\logs" -Force
New-Item -ItemType File -Path "C:\logs\incidentes.json" -Force
New-Item -ItemType File -Path "C:\logs\incidentes_alertas.log" -Force

#    Edita detector_unificado.py y ajusta las rutas:
#      INCIDENTS_JSON = r"C:\logs\incidentes.json"
#      ALERTS_LOG     = r"C:\logs\incidentes_alertas.log"

# 5) (Opcional) Instalar Winlogbeat y configurar salida a C:\logs\incidentes.json
#    Descomprime Winlogbeat, edita winlogbeat.yml (input: Security; output.file a C:\logs).
#    Instala it: .\install-service-winlogbeat.ps1
#    Inicia it: Start-Service winlogbeat

# 6) (Opcional) Coordinación con Logstash si lo usas, apuntando a "C:\logs\incidentes.json".

# 7) Ejecutar Detector desde PowerShell (como Administrador):
python detector_unificado.py

# 8) Cuando quieras informe, detener detector (Ctrl+C) y subir:
Get-Content C:\logs\incidentes_alertas.log   # este es el fichero que subes a la web
13. Soporte y Contacto
Si encuentras errores de instalación o ejecución:

Verifica que Python 3 y PIP estén correctamente instalados.

Revisa que los paths en detector_unificado.py (INCIDENTS_JSON y ALERTS_LOG) apunten a rutas válidas en tu sistema.

Asegúrate de que tienes permisos de lectura/escritura sobre esos ficheros.

Comprueba que Filebeat/Winlogbeat o Logstash estén ejecutándose y generen el JSON con eventos.

Si tras revisar todo sigue sin funcionar, ponte en contacto con nosotros en soporte@tusitio.com indicando:

Captura de pantalla completa del error.

Mensaje de la consola completo.

Detalles de sistema operativo y versiones (Windows 10/11, Ubuntu 20.04, Python 3.x, Beats/Logstash).

