README.md
markdown
Copiar
Editar
# Script 6: Simulador de Ataques ENS

**Versión:** 1.0  
**Autor:** Daniel González Braza  
**Fecha:** Junio 2025  

---

## 1. Descripción

El **Simulador de Ataques ENS** (Script 6) es una herramienta en Python basada en [Scapy](https://scapy.net/) que permite a las PYMEs:

- Realizar escaneos de puertos TCP/UDP en un host de la red local.  
- Ejecutar un **ICMP flood** ligero contra el objetivo.  
- Detectar servicios inseguros (p.ej. FTP anónimo, Telnet abierto).  
- Generar un informe en formato JSON (`informe_simulador.json`) con los resultados detectados.

Su propósito es ayudar a identificar _vectores de ataque_ antes de que un atacante real los descubra. Está pensado para usarse en un entorno de laboratorio o red interna, **jamás contra hosts externos sin permiso**.

---

## 2. Requisitos Previos

1. **Sistema Operativo recomendado:**  
   - Linux (distribuciones basadas en Debian/Ubuntu, CentOS, etc.).  
   - También funcionará en WSL2 con redes correctamente configuradas, pero se aconseja un Linux “nativo”.

2. **Permisos de administrador (root):**  
   Scapy requiere sockets raw para enviar paquetes SYN/ICMP. Por ello, el script debe ejecutarse con `sudo` o como usuario root.

3. **Python 3.8+**  
   - Comprobar versión:  
     ```bash
     python3 --version
     ```
     Debe devolver `Python 3.x.x`.

4. **Dependencias Python**  
   Instálalas mediante pip:
   ```bash
   sudo apt update
   sudo apt install -y python3-pip python3-venv
Luego crea un entorno virtual y activa:

bash
Copiar
Editar
cd /ruta/a/la/carpeta/simulador
python3 -m venv simulador_env
source simulador_env/bin/activate
pip install --upgrade pip
pip install -r requirements.txt
En el archivo requirements.txt deben aparecer al menos:

nginx
Copiar
Editar
scapy
requests        # (si en alguna versión futura usas peticiones HTTP)
(Nota: si sigues usando sr1(...)/send(...) de Scapy, normalmente scapy es suficiente.)

3. Archivos incluidos
simulador_ataques.py
Script principal que contiene toda la lógica de escaneo.

requirements.txt
Lista de dependencias Python (actualmente solo Scapy).

README.md
Este fichero, con instrucciones de instalación y uso.

ejemplo_config.json (opcional)
Un JSON de ejemplo mostrando la estructura de salida si quieres compartir formatos.

4. Uso Básico
Preparar entorno Python

bash
Copiar
Editar
cd /ruta/a/la/carpeta/simulador
python3 -m venv simulador_env
source simulador_env/bin/activate
pip install --upgrade pip
pip install -r requirements.txt
Comprobar conectividad
Antes de ejecutar el script, asegúrate de que el host objetivo responde (por ejemplo, con un ping).

bash
Copiar
Editar
ping -c 3 192.168.10.15
Ejecutar simulador

bash
Copiar
Editar
sudo python3 simulador_ataques.py <IP_OBJETIVO> [opciones]
<IP_OBJETIVO>: IP del host que deseas escanear (emanente de tu red interna).

Opciones disponibles:

--tcp-ports P1 P2 ... Pn
Lista de puertos TCP a escanear (ej.: --tcp-ports 22 80 443 3306).
Si no se especifica, por defecto escanea [22, 80, 443].

--udp-ports U1 U2 ... Um
Lista de puertos UDP a escanear (ej.: --udp-ports 53 161 161).
Por defecto: [53].

--icmp-flood N
Cantidad de paquetes ICMP que enviar. Por defecto: 0 (no hace flood).

--timeout T
(Opcional) Tiempo en segundos de espera por respuesta en cada intento (valor por defecto: 1s).

--help
Muestra ayuda y todas las opciones disponibles.

Ejemplo completo:

bash
Copiar
Editar
sudo python3 simulador_ataques.py 192.168.10.15 \
  --tcp-ports 22 80 443 3306 \
  --udp-ports 53 161 \
  --icmp-flood 5 \
  --timeout 2
Interpretación de la salida

En pantalla verás líneas parecidas a:

less
Copiar
Editar
[2025-06-05 11:22:10] Iniciando simulador contra 192.168.10.15

[2025-06-05 11:22:10] Ejecutando TCP SYN scan en [22, 80, 443, 3306]
-> Puertos TCP abiertos: [22, 80]

[2025-06-05 11:22:11] Iniciando ICMP flood (5 paquetes) a 192.168.10.15
-> ICMP flood terminado

[2025-06-05 11:22:11] Iniciando UDP scan en [53, 161]
-> Puertos UDP abiertos/filtrados: [53]

[2025-06-05 11:22:12] Informe guardado en /home/admin/ens-scripts/simulador/informe_simulador.json

[2025-06-05 11:22:12] Fin del simulador.
Esto quiere decir:

El script abrió sockets raw para enviar paquetes SYN a los puertos indicados y recopiló las respuestas.

Mostró en pantalla los puertos abiertos para TCP y UDP.

Hizo un “ICMP flood” de X paquetes (si se pedía).

Guardó un archivo JSON de resumen en la misma carpeta (por defecto informe_simulador.json).

Contenido de informe_simulador.json
Un ejemplo sencillo de JSON que genera:

json
Copiar
Editar
{
  "target": "192.168.10.15",
  "timestamp": "2025-06-05 11:22:10",
  "tcp_abiertos": [22, 80],
  "ftp_anonimo": false,
  "telnet_banner": null,
  "icmp_enviados": 5,
  "udp_abiertos": [53]
}
tcp_abiertos: lista de puertos TCP que respondieron con SYN-ACK.

ftp_anonimo: true si detecta FTP con acceso anónimo (si se implementa módulo FTP).

telnet_banner: cadena de banner Telnet si está presente, o null si no hay Telnet.

icmp_enviados: número de paquetes ICMP enviados (solo para pruebas).

udp_abiertos: lista de puertos UDP que no devolvieron ICMP “port unreachable” (pueden estar abiertos o filtrados).

Subida del JSON a la web

Accede a tu portal en la sección “Paso 2 – Subir resultados Simulador”.

Selecciona el archivo informe_simulador.json y haz clic en “Enviar”.

El sistema procesará el JSON y te mostrará un diagnóstico automático, por ejemplo:

yaml
Copiar
Editar
• Host auditado: 192.168.10.15
• Puertos TCP abiertos: 22 (SSH), 80 (HTTP) → Verificar si necesitamos exponer SSH: en caso contrario, filtrar; asegurar que el servidor HTTP tenga certificados válidos.
• Puerto UDP abierto/filtrado: 53  → Confirmar si DNS debe ser público; de lo contrario, bloquear.
• FTP anónimo: false  → OK.
• Telnet no detectado: null  → OK.
• ICMP flood: 5 paquetes respondidos  → respuesta normal, dentro de pruebas internas.
Opcionalmente, desde la misma web podrás descargar un PDF de diagnóstico consolidado.

5. Recomendaciones de uso y buenas prácticas
Ejecutar siempre en red controlada

Nunca apuntar el simulador a hosts externos sin autorización expresa.

Idealmente, utilizar una red separada o VLAN de laboratorio.

Ejecutar con cuidado el ICMP flood (–icmp-flood)

Los paquetes ICMP pueden saturar la red si se envían demasiados.

Limítalo a un número bajo (5–10) para probar conectividad, no para lanzar un verdadero DoS.

Revisar servicios descubiertos

Si se detecta un FTP con acceso anónimo, se recomienda directamente deshabilitarlo o reconfigurarlo.

Para HTTP/HTTPS: asegúrate de que vayan con certificados válidos y versiones actualizadas de software.

Si Telnet está abierto, considera deshabilitarlo y usar SSH solamente.

Verificar dependencias

Scapy en algunas distribuciones requiere instalar paquetes del sistema, p.ej. sudo apt install libpcap-dev.

Si el script no envía o recibe paquetes, comprueba que no falten librerías nativas:

bash
Copiar
Editar
sudo apt install build-essential python3-dev libpcap-dev
pip install scapy
Revisar permisos en Linux

Asegúrate de que el usuario que ejecute el script tenga privilegios para usar sockets raw. En distribuciones modernas, bastará con sudo.

Verifica que no exista un firewall local que bloquee ICMP o SYN. Para pruebas, puedes temporalmente desactivar UFW o nftables:

bash
Copiar
Editar
sudo ufw disable
Interpretación de resultados y siguiente paso

Una vez subido el JSON al sitio, sigue las recomendaciones que el sistema te devuelva.

Si la web te indica “Puerto 22 abierto → filtrar” y la PYME no necesita acceso SSH, deben modificar su firewall o reglas de iptables/ufw.

Repite esta prueba periódicamente (p.ej. cada 3 meses) para asegurarte de que no aparecen nuevos servicios expuestos.

6. Estructura final de carpetas
Cuando la PYME descomprima el ZIP, debería ver algo así:

pgsql
Copiar
Editar
simulador_ataques/
├── README.md
├── requirements.txt
├── simulador_ataques.py
└── ejemplo_config.json   (opcional, demo de salida JSON)
simulador_ataques.py: script principal.

requirements.txt: contiene

nginx
Copiar
Editar
scapy
README.md: instrucciones que acabas de leer.

ejemplo_config.json: (ejemplo) muestra cómo se verá el JSON final.

7. Cómo adaptar el Script 6 a un servicio “en la nube” (opcional)
Si quisieras que la PYME no tenga que ejecutar localmente el script, podrías:

Proporcionar una máquina virtual ya configurada

Ofrecer un enlace a una imagen de VM (VirtualBox/VMWare) que ya tenga instalado Python + Scapy + simulador_ataques.py. Así solo importan la VM, abren la consola e introducen los comandos.

Crear un contenedor Docker (solo para Linux)

Desarrollar un Dockerfile que instale Scapy y ejecute simulador_ataques.py.

La PYME solo tendría que ejecutar algo como:

bash
Copiar
Editar
docker build -t simulador-ens .
docker run --net=host --rm -it simulador-ens 192.168.10.15 --tcp-ports 22 80 --icmp-flood 5
De esta forma no se preocupan por dependencias locales.

Servicio web remoto (no recomendado para pruebas LAN)

Podrías ofrecer una API REST que reciba la IP y puertos y ejecute internamente Scapy en tu servidor.

Sin embargo, no es recomendable para una PYME: esto implicaría exponer la red interna al mundo y desconfiar de los resultados (dependencia de la conectividad externa). Enunciamos esta opción solo como curiosidad.

Fin del README