# vulnerar_windows.ps1
# Script para inyectar (V) o limpiar (C) vulnerabilidades de los controles Op.acc.*

# Comprueba que se ejecuta como Administrador
if (-not (
    [Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()
).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator)) {
    Write-Error "Este script debe ejecutarse como Administrador."
    exit 1
}

# Menú interactivo
Write-Host ""
Write-Host "==============================="
Write-Host "Seleccione modo:"
Write-Host "  V = Vulnerar"
Write-Host "  C = Clean (limpiar vulnerabilidades)"
Write-Host "==============================="
$modo = Read-Host "Modo"

switch ($modo.ToUpper()) {

    'V' {
        Write-Host "`nModo: Vuln"
        Write-Host "==============================="

        # --- Control Op.acc.1 – Identificación ---
        Write-Host "`nControl Op.acc.1 – Identificación"
        Write-Host " • Crear usuario 'prueba' sin contraseña y que nunca expire"
        net user prueba "" /add /passwordreq:no /expires:never | Out-Null

        # --- Control Op.acc.2 & Op.acc.5 – Privilegios y RDP ---
        Write-Host "`nControl Op.acc.2 – Requisitos de acceso"
        Write-Host " • Añadir 'prueba' al grupo Administradores"
        Add-LocalGroupMember -Group "Administradores" -Member "prueba"
        Write-Host " • Añadir 'prueba' al grupo 'Usuarios de escritorio remoto'"
        Add-LocalGroupMember -Group "Usuarios de escritorio remoto" -Member "prueba"
        Write-Host " • Añadir 'prueba' al grupo 'Operadores de copia de seguridad'"
        Add-LocalGroupMember -Group "Operadores de copia de seguridad" -Member "prueba"

        Write-Host "`nControl Op.acc.5 – Mecanismos de autenticación (usuarios externos)"
        Write-Host " • Habilitar RDP"
        Set-ItemProperty -Path "HKLM:\System\CurrentControlSet\Control\Terminal Server" `
            -Name "fDenyTSConnections" -Value 0
        Write-Host " • Habilitar cuenta 'Administrador'"
        Enable-LocalUser -Name "Administrador"

        # --- Control Op.acc.4 – Gestión de derechos de acceso ---
        Write-Host "`nControl Op.acc.4 – Gestión de derechos de acceso"
        Write-Host " • Crear usuario 'pruebaDisabled' y deshabilitarlo"
        net user pruebaDisabled "P@ssw0rd!" /add /expires:never | Out-Null
        Disable-LocalUser -Name "pruebaDisabled"

        # --- Control Op.acc.6 – Políticas de contraseña (usuarios internos) ---
        Write-Host "`nControl Op.acc.6 – Políticas de contraseña"
        Write-Host " • Establecer PASS_MAX_DAYS=999"
        net accounts /maxpwage:999 | Out-Null
        Write-Host " • Establecer PASS_MIN_DAYS=0"
        net accounts /minpwage:0 | Out-Null
        Write-Host " • Establecer INTENTOS_FALLIDOS=0"
        net accounts /lockoutthreshold:0 | Out-Null

        Write-Host "`n¡Operación 'Vuln' completada!"
    }

    'C' {
        Write-Host "`nModo: Clean"
        Write-Host "==============================="

        # --- Control Op.acc.1 – Identificación ---
        Write-Host "`nControl Op.acc.1 – Identificación"
        Write-Host " • Eliminar usuario 'prueba'"
        Remove-LocalUser -Name "prueba" -ErrorAction SilentlyContinue

        # --- Control Op.acc.4 – Gestión de derechos de acceso ---
        Write-Host "`nControl Op.acc.4 – Gestión de derechos de acceso"
        Write-Host " • Eliminar usuario 'pruebaDisabled'"
        Remove-LocalUser -Name "pruebaDisabled" -ErrorAction SilentlyContinue

        # --- Restauración de RDP y cuenta Administrador ---
        Write-Host "`nControl Op.acc.5 – Mecanismos de autenticación (usuarios externos)"
        Write-Host " • Deshabilitar RDP"
        Set-ItemProperty -Path "HKLM:\System\CurrentControlSet\Control\Terminal Server" `
            -Name "fDenyTSConnections" -Value 1
        Write-Host " • Deshabilitar cuenta 'Administrador'"
        Disable-LocalUser -Name "Administrador"

        # --- Control Op.acc.6 – Políticas de contraseña (usuarios internos) ---
        Write-Host "`nControl Op.acc.6 – Políticas de contraseña"
        Write-Host " • Restaurar PASS_MAX_DAYS=90"
        net accounts /maxpwage:90 | Out-Null
        Write-Host " • Restaurar PASS_MIN_DAYS=1"
        net accounts /minpwage:1 | Out-Null
        Write-Host " • Restaurar INTENTOS_FALLIDOS=5"
        net accounts /lockoutthreshold:5 | Out-Null

        Write-Host "`n¡Operación 'Clean' completada!"
    }

    Default {
        Write-Error "Modo inválido. Ejecute de nuevo y elija V o C."
        exit 1
    }
}