using System;

public static class DataIntegrityChecker
{
    // Static method to check if the data array contains missing or empty values
    public static bool IsMissingData(string[] data)
    {
        if (data == null || data.Length == 0) 
        {
            return true; // If the data array is null or empty, consider it as missing data
        }

        foreach (string d in data)
        {
            if (string.IsNullOrEmpty(d)) return true; // Return true if any value is null or empty
        }
        return false; // Return false if all data values are valid
    }

    // Static method to check if a specific map property (e.g., map name) is valid
    public static bool IsValidMapName(string mapName)
    {
        return !string.IsNullOrEmpty(mapName) && mapName.Length > 2; // Check if the map name is valid (non-null and has more than 2 characters)
    }

    // Static method to verify if numeric data is within a valid range (e.g., map size)
    public static bool IsValidMapSize(int size, int minSize, int maxSize)
    {
        return size >= minSize && size <= maxSize; // Check if size is within the allowed range
    }

    // Add other static methods for additional integrity checks as needed
}
