using System;

public static class EnumExtensions
{   
    // Get the number of elements in an enum
    public static int Length<T>() where T : Enum
    {
        return Enum.GetValues(typeof(T)).Length;
    }

    // Get the next element in an enum
    public static T Next<T>(this T src) where T : Enum
    {
        var Arr = (T[])Enum.GetValues(src.GetType());
        int j = Array.IndexOf(Arr, src) + 1;
        return (Arr.Length==j) ? Arr[0] : Arr[j];
    }
}