using UnityEngine;
using System.Linq;
using System.Collections.Generic;

public static class FirestoreKeys
{
    // Firestore main paths
    public const string SHARED_MAPS_PATH = "Shared_Maps"; // All the shared maps
    public const string USER_MAPS_PATH = "Users"; // All the users and data
    public const string USER_PURCHASES = "Purchases"; // All the shared maps of the user
    public const string USER_INTERACTED_MAPS = "Interacted_Maps"; // All the maps the usar casted a vote or a rate
    // Map data attributes
    public const string MAP_KEY = "key"; // unique map key
    public const string MAP_NAME = "name"; // name of the map
    public const string MAP_LOWER_CASE_NAME = "lowerCaseName"; // name of the map in lower case
    public const string MAP_DESCRIPTION = "description"; // description of the map
    public const string MAP_HOLES = "holes"; // data/tiles of the map
    public const string MAP_DATA = "data"; // data/tiles of the map
    public const string MAP_AUTHOR = "authorName"; // author of the map
    public const string MAP_AUTHOR_ID = "authorID"; // short id of the author
    public const string META_DATA_DATE_CREATED = "dateCreated"; // date of creation
    public const string META_DATA_DATE_MODIFIED = "dateModified"; // date of last modification
    public const string META_DATA_RATING = "totalRating";
    public const string META_DATA_RATES = "ratingCount"; // number of ratings
    public const string META_DATA_DOWNLOADS = "downloads";
    public const string META_DATA_LIKES = "likes";
    public const string META_DATA_FILE_SIZE = "fileSize"; // size of the map file

    // Get the map data dictionary
    public static Dictionary<string, object> GetMapData(MapData_ES3 mapData, string author, string authorUUID, string fileDataPath)
    {
        // Convert holesPar to Dictionary<string, Dictionary<string, object>>
        Dictionary<string, Dictionary<string, object>> firestoreHolesPar = 
            mapData.holesPar.ToDictionary(
                kvp => kvp.Key.ToString(), // Convert int key to string
                kvp => new Dictionary<string, object> 
                {
                    { "parValue", kvp.Value.parValue },
                    { "posX", kvp.Value.posX },
                    { "posY", kvp.Value.posY }
                }
            );

        return new Dictionary<string, object>
        {
            {MAP_KEY, mapData.key},
            {MAP_NAME, mapData.name},
            {MAP_LOWER_CASE_NAME, mapData.name.ToLower()},
            {MAP_DESCRIPTION, mapData.description},
            {MAP_HOLES, firestoreHolesPar},
            {MAP_DATA, fileDataPath},
            {MAP_AUTHOR, author},
            {MAP_AUTHOR_ID, authorUUID},
            {META_DATA_DATE_CREATED, mapData.creationDate},
            {META_DATA_DATE_MODIFIED, mapData.lastModifiedDate},
            {META_DATA_FILE_SIZE, mapData.fileSize},
            {META_DATA_RATING, 0},
            {META_DATA_RATES, 0},
            {META_DATA_DOWNLOADS, 0},
            {META_DATA_LIKES, 0}
        };
    }

    // Get the map cloud name used as the document name in Firestore
    public static string GetMapCloudName(string mapName, string authShortID)
    {
        return mapName + "¿-?" + authShortID;
    }
}
