using UnityEngine;

public static class LocalSaveKeys
{
    // Base paths
    public const string BASE_PATH = "Maps/";
    public const string INDEX_PATH = "Index/";
    public const string LOCAL_PATH = "Local/";
    public const string DOWNLOADED_PATH = "Downloaded/";

    // Map key prefix
    public const string MAIN_KEY = "map_"; // Each file has only one key
    public const string TEMP_SUFFIX = "_temp"; // Temporary file suffix

    // Keys for local levels and indexes
    public const string LOCAL_MAPS_KEY = "localMapsScore";
    public const string LEVELS_SCORE_PATH = "Local/LevelsScore/LevelsScoreData";

    // Key for saving the map dictionary
    public const string MAP_DICT_LOCAL = "localIndex";
    public const string MAP_DICT_DOWNLOADED = "downloadedIndex";

    // Save types
    public enum SaveType
    {
        Local,
        Index,
        Download
    }

    // Get the full map path depending on whether it's local, indexed, or downloaded
    public static string GetMapPath(string mapName, SaveType saveType)
    {
        string basePath = BASE_PATH;

        switch (saveType)
        {
            case SaveType.Local:
                basePath += LOCAL_PATH;
                break;
            case SaveType.Index:
                basePath += INDEX_PATH;
                break;
            case SaveType.Download:
                basePath += DOWNLOADED_PATH;
                break;
        }

        return basePath + mapName;
    }

    // Get the full index path depending on whether it's local or downloaded
    public static string GetIndexPath(SaveType saveType)
    {
        string basePath = BASE_PATH + INDEX_PATH;

        switch (saveType)
        {
            case SaveType.Index:
            case SaveType.Local:
                basePath += MAP_DICT_LOCAL;
                break;
            case SaveType.Download:
                basePath += MAP_DICT_DOWNLOADED;
                break;
        }

        return basePath;
    }

    // Get the map name, key, and paths
    public static void GetLocalSaveInfo(out string mapName, out string mapKey, out string mapPath, out string tempPath, LocalSaveKeys.SaveType saveType)
    {
        // Retrieve mapName from wherever you store or determine it
        mapName = PlayerPrefs.GetString(KeyManager.saveKeysDict[KeyManager.SaveKey.EditMapKey]);

        // Generate mapKey based on mapName
        mapKey = MAIN_KEY;

        // Generate mapPath and tempPath based on the mapName and saveType
        mapPath = GetMapPath(mapName, saveType);
        tempPath = mapPath + TEMP_SUFFIX;
    }
}
