
using System.Collections.Generic;

// Manages all the player prefs keys
public static class KeyManager
{   
    // Keys used to control the game -> needs refactor -> after game testing
    public enum SaveKey
    {
        ShootPower,
        ZoomIntensity,
        ExploringMode,
        EditMapKey
    }

    // The different types of objects in the game
    public enum ObjectType
    {
        Meta,
        CheckPoint,
        Booster,
        DeadZone
    }

    // The different types of boosters in the game
    public enum BoosterType
    {
        Impulse_Right,
        Impulse_Left,
        Impulse_Up,
        Impulse_Down,
        Impulse_UpRight,
        Impulse_UpLeft,
        Impulse_DownRight,
        Impulse_DownLeft,
        Random,
        Random_Axis,
        Random_Diagonals,
        Random_X,
        Random_Y,
        Random_Diagonal_UpRight,
        Random_Diagonal_UpLeft
    }

    // Encapsulates the save keys and their corresponding strings
    public static Dictionary<SaveKey, string> saveKeysDict = new Dictionary<SaveKey, string>
    {
        { SaveKey.ShootPower, "power" },
        { SaveKey.ZoomIntensity, "zoom" },
        { SaveKey.ExploringMode, "exploring" },
        { SaveKey.EditMapKey, "editMap" }
    };    
}