using UnityEngine;

public static class ShopKeys
{
  // Base paths
  public const string CUR_TYPE_COIN = "Coin";
  public const string CUR_TYPE_DIAMOND = "Diamond";

  // Base paths
  public const string BASE_PATH = "Shop/";
  public const string CURRENCY_PATH = "ShopData"; // The currency of the player
  public const string EQUIP_PATH = "EquipData/"; // The items bought by the player
  public const string SKIN_FILE = "SkinData"; // The skins bought by the player
  public const string TRAIL_FILE = "TrailData"; // The levels bought by the player

  public static string GetCurrencyPath()
  {
    return BASE_PATH + CURRENCY_PATH;
  }

  public static string GetEquipPath(string equipType)
  {
    return BASE_PATH + EQUIP_PATH + equipType;
  }
}