using UnityEngine;
using UnityEngine.UI;
using UnityEngine.EventSystems;

public class ButtonTextNudge : MonoBehaviour
{
    public Button button;
    public RectTransform[] itemsToNudge;  // Array of RectTransforms to nudge
    public Vector2 pressedOffset = new Vector2(0, -3);
    private Vector2[] originalPos;  // Store the original positions of all RectTransforms

    void Start()
    {
        // Initialize the array to hold the original positions
        originalPos = new Vector2[itemsToNudge.Length];

        // Store the original positions of each item in the array
        for (int i = 0; i < itemsToNudge.Length; i++)
        {
            originalPos[i] = itemsToNudge[i].anchoredPosition;
        }

        button.onClick.AddListener(() => {
            // Do your normal button logic here (if needed)
        });

        // Add pressed and released effect
        var trigger = button.GetComponent<Button>().gameObject.AddComponent<EventTrigger>();

        // Pointer Down (When button is pressed)
        EventTrigger.Entry entryDown = new EventTrigger.Entry();
        entryDown.eventID = EventTriggerType.PointerDown;
        entryDown.callback.AddListener((data) => {
            if (button.interactable == false) return; // Check if the button is interactable
            // Apply pressed offset to each RectTransform in the array
            for (int i = 0; i < itemsToNudge.Length; i++)
            {
                if (itemsToNudge[i] != null)
                {
                    itemsToNudge[i].anchoredPosition = originalPos[i] + pressedOffset;
                }
            }
        });

        // Pointer Up (When button is released)
        EventTrigger.Entry entryUp = new EventTrigger.Entry();
        entryUp.eventID = EventTriggerType.PointerUp;
        entryUp.callback.AddListener((data) => {
            // Reset each RectTransform back to its original position
            for (int i = 0; i < itemsToNudge.Length; i++)
            {
                if (itemsToNudge[i] != null)
                {
                    itemsToNudge[i].anchoredPosition = originalPos[i];
                }
            }
        });

        // Add the trigger events to the event trigger component
        trigger.triggers.Add(entryDown);
        trigger.triggers.Add(entryUp);
    }
}
