using UnityEngine;
using UnityEngine.UI;
using TMPro;

public class InputHandler : MonoBehaviour
{
    // Reference to the input field
    public TMP_InputField inputField;
    public TextMeshProUGUI placeholder;
    public int placeholderMax = 22;
    public int placeholderMin = 14;
    public bool isSelected = false;


    // Check if the input field is empty and thus, set the placeholder size
    public void CheckInputField()
    {
        if (string.IsNullOrWhiteSpace(inputField.text))
        {
            if (inputField.isFocused)
            {
                AlignTop();
            }
            else
            {
                AlignMid();
            }
        }
        else
        {
            AlignTop();
        }
    }

    public void OnSelect()
    {
        isSelected = true;
        AlignTop();
    }

    public void OnDeselect()
    {
        isSelected = false;
        CheckInputField();
    }

    // Aligns the placeholder to the top with a smaller font size
    public void AlignTop()
    {
        placeholder.fontSize = placeholderMin;
        placeholder.alignment = TextAlignmentOptions.TopLeft;
        if (inputField.isFocused || isSelected)
        {
            placeholder.color = new Color32(0, 255, 255, 255);
        }
        else
        {
            placeholder.color = new Color32(195, 195, 195, 255);
        }
    }

    // Aligns the placeholder to the center with a larger font size
    public void AlignMid()
    {
        placeholder.fontSize = placeholderMax;
        placeholder.alignment = TextAlignmentOptions.MidlineLeft;
        placeholder.color = new Color32(195, 195, 195, 255);
    }



}
