using UnityEngine;
using UnityEngine.UI;
using TMPro;

public class MaxCharHandler : MonoBehaviour
{
    // Reference to the input field
    public TMP_InputField inputField;
    public TextMeshProUGUI indicator;
    public int maxChar = 36;

    public void Awake()
    {
        inputField.characterLimit = maxChar;
        inputField.onValueChanged.AddListener(delegate { UpdateCharIndicator(); });
    }

    // Check if the input field is empty and thus, set the placeholder size
    public void UpdateCharIndicator()
    {
        indicator.text = inputField.text.Length + "/" + maxChar;
        if (inputField.text.Length == 0)
        {
            indicator.color = new Color32(0, 0, 0, 0); // Hide the indicator
        }
        else
        {
            indicator.color = new Color32(255, 255, 255, 255); // Show the indicator
        }
    }
}