using UnityEngine;
using UnityEngine.UI;
using TMPro;

public class PasswordHandler : MonoBehaviour
{
    // Reference to the input field
    public TMP_InputField inputField;
    public bool isPasswordVisible = false;
    public Image passwordIcon;
    public Sprite[] passwordSprites;

    // Check if the input field is empty and thus, set the placeholder size
    public void CheckPassword()
    {
        if (string.IsNullOrWhiteSpace(inputField.text))
        {
            passwordIcon.enabled = false;
        }
        else
        {
            passwordIcon.enabled = true;
        }

        if (isPasswordVisible)
        {
            inputField.contentType = TMP_InputField.ContentType.Standard;
            passwordIcon.sprite = passwordSprites[0];
        }
        else
        {
            inputField.contentType = TMP_InputField.ContentType.Password;
            passwordIcon.sprite = passwordSprites[1];
        }
        // Force the input field to update
        inputField.ForceLabelUpdate();
    }

    public void TogglePasswordVisibility()
    {
        isPasswordVisible = !isPasswordVisible;
        CheckPassword();
    }



}
