using UnityEngine;
using UnityEngine.UI;
using TMPro;

public class TabController : MonoBehaviour
{
    public GameObject[] panels; // Array of panels
    public Button[] buttons;   // Array of tab buttons
    public Image[] icons; // Array of tab images

    public Color32 activeTab = new Color32(123, 123, 123, 255);
    public Color32 inactiveTab = new Color32(80, 80, 80, 255);

    public Color32 activeText = new Color32(255, 255, 255, 255);
    public Color32 inactiveText = new Color32(103, 103, 103, 255);

    void Start()
    {
        // Assign listeners to buttons
        for (int i = 0; i < buttons.Length; i++)
        {
            int index = i; // Local copy for the closure
            buttons[i].onClick.AddListener(() => SwitchTab(index));
        }

        // Activate the first tab by default
        SwitchTab(0);
        SetTabView(0);
    }

    public void SwitchTab(int index)
    {
        // Activate the selected panel and deactivate others
        for (int i = 0; i < panels.Length; i++)
        {
            panels[i].SetActive(i == index);
        }
    }

    public void SetTabView(int index)
    {
        // Set the color of the tab buttons
        for (int i = 0; i < buttons.Length; i++)
        {
            // If using Button component, reset its highlight state
            var button = buttons[i].GetComponent<Button>();
            button?.OnDeselect(null); // This resets UI selection state

            // Set the color of the tab background
            if (buttons[i].GetComponent<Image>() != null)
            {
                buttons[i].GetComponent<Image>().color = i == index ? activeTab : inactiveTab;
            }
            // Set the color of the tab text
            if (buttons[i].GetComponentInChildren<TMP_Text>() != null)
            {
                buttons[i].GetComponentInChildren<TMP_Text>().color = i == index ? activeText : inactiveText;
            }
        }

        // Set the color of the tab icons
        for (int i = 0; i < icons.Length; i++)
        {
            icons[i].color = i == index ? activeText : inactiveText;
        }
    }
}
