using UnityEngine;
using System.Collections.Generic;

public class Manager_MainMenu : MonoBehaviour
{
  // Ordered as they appear in the game scene
  public GameObject[] menus;
  // Submenus
  public GameObject[] worldMenu;

  // Login menu
  public Manager_Auth manager_Auth;
  public GameObject loginMenu;
  public Warning warning;

  public Manager_SceneFade manager_SceneFade;

  public void Start()
  {
    LoadOpenedMenu();
  }

  private void LoadOpenedMenu()
  {
    int menu = PlayerPrefs.GetInt("OpenedMenu");

    // Don't open any menu if the player hasn't selected any
    if (menu <= 0)
    {
      return;
    }

    menus[menu].SetActive(true);

    // For submenus extra handling
    switch (menu)
    {
      case 1:
        OpenWorldMenu();
        break;
      default:
        break;
    }
  }

  public void OpenWorldMenu()
  {
    int world = PlayerPrefs.GetInt("WorldMenu");
    if (world <= 0)
    {
      return;
    }
    worldMenu[world - 1].SetActive(true);
  }

  public void SetOpenedMenu(int menu)
  {
    PlayerPrefs.SetInt("OpenedMenu", menu);
  }

  public void SetWorldSubMenu(int world)
  {
    PlayerPrefs.SetInt("WorldMenu", world);
  }

  public void CheckLogin()
  {
    if (!manager_Auth.IsUserLoggedIn())
    {
      warning.ShowWarning("You need to be logged in to access this feature.");
      loginMenu.SetActive(true);
    }
    else {
      // If the user is logged in, open the multiplayer menu
      manager_SceneFade.OpenNewViewFade(menus[2]);
      //SetOpenedMenu(1);
    }
  }

}