using UnityEngine;
using TMPro;
using UnityEngine.UI;

public class UI_LevelHolder : MonoBehaviour
{
  [SerializeField] private TextMeshProUGUI indicator; // Reference to the score text
  public TextMeshProUGUI[] stars;
  public TextMeshProUGUI timeRating;
  public Image[] starAchieved;
  public Image timeAchieved;
  private int[] ratings = new int[3];
  private float time;

  // Set the score text for the given hole
  public void SetStarRatings(int[] ratings, float time)
  {
    for (int i = 0; i < ratings.Length; i++)
    {
      stars[i].text = ratings[i].ToString();
    }

    timeRating.text = SecToMin(time) + " min";

    this.ratings = ratings;
    this.time = time;
  }

  // Make it static as -> results menu has the same function
  public string SecToMin(float time)
  {
      int min = Mathf.FloorToInt(time / 60);
      int sec = Mathf.FloorToInt(time % 60);
      return min.ToString("00") + ":" + sec.ToString("00");
  }

  // Set the star achieved for the given hole
  public void SetStarAchieved(int totalStrokes, float totalTime)
  {
    for (int i = 0; i < ratings.Length; i++)
    {
      starAchieved[i].enabled = ratings[i] >= totalStrokes;
    }
    if (time >= totalTime)
    {
      timeAchieved.enabled = true;
    }
    else
    {
      timeAchieved.enabled = false;
    }
  }

  // Set the indicator text
  public void SetIndicator(string text)
  {
    indicator.text = text;
  }
}