using UnityEngine;
using System.Collections.Generic;

public class WorldMenuData : MonoBehaviour
{
  private Dictionary<string, CourseScore.Score> worldData = null;
  [SerializeField] ScoreData scoreData;
  [SerializeField] private UI_LevelHolder uiLevelHolder;
  public void Awake()
  {
    if (ES3.KeyExists(LocalSaveKeys.LOCAL_MAPS_KEY, LocalSaveKeys.LEVELS_SCORE_PATH))
    {
      worldData = ES3.Load<Dictionary<string, CourseScore.Score>>(
        LocalSaveKeys.LOCAL_MAPS_KEY,
        LocalSaveKeys.LEVELS_SCORE_PATH
      );
    }
    else
    {
      Debug.LogWarning("Save file or key does not exist. Initializing an empty dictionary.");
      worldData = new Dictionary<string, CourseScore.Score>();
    }
  }

  // Load the level data for the selected level
  public void LoadLevelData(int index)
  {
    string levelName = scoreData.scorePoints[index].levelName;
    PlayerPrefs.SetInt("LevelIndex", index);
    Debug.Log("Loading level data for " + levelName);

    // Set the baseline data for the level
    int[] ratings = new int[3];
    ratings[0] = scoreData.scorePoints[index].starOne;
    ratings[1] = scoreData.scorePoints[index].starTwo;
    ratings[2] = scoreData.scorePoints[index].starThree;

    float time = scoreData.scorePoints[index].time;

    // Update the UI with the baseline data
    uiLevelHolder.SetStarRatings(ratings, time);

    // Check if there is saved data for the level
    if (worldData.ContainsKey(levelName))
    {
      // Get the saved data for the level
      CourseScore.Score score = worldData[levelName];
      Debug.Log("Total strokes: " + score.totalStrokes);
      Debug.Log("Total score: " + score.totalScore);
      Debug.Log("Total time: " + score.totalTime);


      // Update the UI with the saved data
      uiLevelHolder.SetStarAchieved(score.totalStrokes, score.totalTime);
      string bestTime = uiLevelHolder.SecToMin(score.totalTime);

      // Get and display the level state
      string indicator = $"Best: {score.totalStrokes} Strokes\nTime: {bestTime} min\nScore: {score.totalScore}";
      uiLevelHolder.SetIndicator(indicator);

    }
    else
    {
      Debug.LogWarning("No data found for " + levelName);
      uiLevelHolder.SetStarAchieved(9999, 9999);
      uiLevelHolder.SetIndicator("Never Completed");
    }
  }
}