using UnityEngine;

public class AnimationSync : MonoBehaviour
{
    [Tooltip("Name of the animation state to synchronize.")]
    public string animationStateName = "Idle";

    [Tooltip("Length of the animation in seconds.")]
    public float animationLength = 101f;
    public Manager_LevelEditor managerLevelEditor;
    public Animator animator;

    void Awake()
    {
        managerLevelEditor = FindObjectOfType<Manager_LevelEditor>();
        managerLevelEditor.OnTestingModeActivated += SyncAnimation;
        if (managerLevelEditor != null)
        {
            managerLevelEditor.OnTestingModeActivated += SyncAnimation;
        }
    }

    void OnDestroy()
    {
        if (managerLevelEditor != null)
        {
            managerLevelEditor.OnTestingModeActivated -= SyncAnimation;
        }
    }

    /// <summary>
    /// Syncs the animation playback to a global time so all instances stay in phase.
    /// </summary>
    public void SyncAnimation()
    {
        if (this == null || animator == null)
            return;
        if (animator == null)
        {
            Debug.LogError("Animator component not found on this GameObject.");
            Debug.Log(gameObject.name);
            return;
        }
        float globalTime = Time.time;
        float normalizedTime = (globalTime % animationLength) / animationLength;
        //Debug.Log($"Global Time: {globalTime}, Normalized Time: {normalizedTime}");
        animator.Play(animationStateName, 0, normalizedTime);
        animator.Update(0f); // Apply the update immediately to avoid delay
    }
}
