using UnityEngine;
using UnityEngine.Tilemaps;

[CreateAssetMenu(fileName = "NewCustomRuleTile", menuName = "Tiles/Custom Rule Tile")]
public class CustomRuleTile : RuleTile
{
    public Vector3 objectScale = new Vector3(0.5f, 0.5f, 1.0f); // Default scale

    public override bool StartUp(Vector3Int position, ITilemap tilemap, GameObject instantiatedGameObject)
    {
        base.StartUp(position, tilemap, instantiatedGameObject);

        if (instantiatedGameObject != null)
        {
            // Set the scale of the instantiated GameObject
            instantiatedGameObject.transform.localScale = objectScale;
        }

        return true;
    }
}
