using TMPro;
using UnityEngine;

public class InputFieldHandler : MonoBehaviour
{
    public TMP_InputField inputField;
    public TMP_Text warningText;
    public GameObject quickSearch;
    public Manager_MapQuery mapQueryManager;

    private bool suppressEndEdit = false;
    

    public void ClearInputField()
    {
        suppressEndEdit = true;
        inputField.text = string.Empty;
        warningText.text = string.Empty;
        quickSearch.SetActive(true);
        mapQueryManager.CleanMaps();
    }
}
