using UnityEngine;

[CreateAssetMenu(fileName = "NewLevelData", menuName = "ScriptableObjects/LevelData", order = 1)]
public class ScoreData : ScriptableObject
{
    [System.Serializable] // Mark this as serializable so it can be edited in the Inspector
    public class Score
    {
        public string levelName = "Level";
        public int index = 0;
        public int starOne = 0;
        public int starTwo = 0;
        public int starThree = 0;
        public float time = 0f;
    }

    [SerializeField]
    public Score[] scorePoints; // Array of Score objects
}
