using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class Cooldown : MonoBehaviour
{
    private bool isCooldown = false;
    private float cooldownTime = 1.0f; // Default cooldown time in seconds
    private float currentTime = 0.0f;

    private void Update()
    {
        // If the cooldown is active, update the current time
        if (isCooldown)
        {
            currentTime += Time.deltaTime;

            if (currentTime >= cooldownTime)
            {
                isCooldown = false;
                currentTime = 0.0f;
            }
        }
    }

    // Start the cooldown
    public void StartCooldown(float cooldown)
    {
        Debug.Log("Starting cooldown");
        if (!isCooldown)
        {
            isCooldown = true;
            cooldownTime = cooldown;
        }
    }

    // Get the progress of the cooldown in a range of 0.0f to 1.0f
    public float GetCooldownProgress()
    {
        if (isCooldown)
        {
            return currentTime / cooldownTime;
        }

        return 0.0f;
    }

    // Get the cooldown time in seconds
    public int GetCooldownTime()
    {
        return (int)(cooldownTime - currentTime) + 1;
    }

    // Check if the cooldown is active
    public bool IsOnCooldown()
    {
        return isCooldown;
    }
}