using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class Manager_SceneFade : MonoBehaviour
{
    [SerializeField] private Animator animator = null;
    [SerializeField] private Transform fadeView = null;
    private float defaultFadeTime = 0.5f;
    private bool isFading = false;

    private void Awake()
    {
        DontDestroyOnLoad(gameObject);
    }

    public bool IsFading()
    {
        return isFading;
    }

    public void SceneFade(bool forward)
    {
        if (forward)
        {
            fadeView.localScale = new Vector3(1, 1, 1);
        }
        else
        {
            fadeView.localScale = new Vector3(-1, 1, 1);
        }
        isFading = true;
        animator.SetTrigger("FadeIn");
    }

    public void OnFadeComplete(bool forward)
    {
        if (forward)
        {
            fadeView.localScale = new Vector3(1, 1, 1);
        }
        else
        {
            fadeView.localScale = new Vector3(-1, 1, 1);
        }
        isFading = false;
        animator.SetTrigger("FadeOut");
    }

    public void OpenNewViewFade(GameObject newView)
    {
        fadeView.localScale = new Vector3(1, 1, 1);
        StartCoroutine(FadeIn(newView, true, defaultFadeTime));
    }

    public void CloseCurrentViewFade(GameObject newView)
    {
        fadeView.localScale = new Vector3(-1, 1, 1);
        StartCoroutine(FadeIn(newView, false, defaultFadeTime));
    }

    IEnumerator FadeIn(GameObject newView, bool open, float time)
    {
        animator.SetTrigger("FadeIn");
        yield return new WaitForSeconds(time);
        animator.SetTrigger("FadeOut");
        newView.SetActive(open);
    }
}