using UnityEngine;
using UnityEngine.UI;
using TMPro;

public class CooldownDisplayer : MonoBehaviour
{
    public Cooldown cooldown;
    public Image imageCooldown;
    public Image background;

    public bool reverseFill = false;
    public bool ShowText = false;
    public TextMeshProUGUI textCooldown;
    
    private void Update()
    {   
        // If the cooldown is not active, clean the image
        if (!cooldown.IsOnCooldown())
        {
            CleanImage();
            return;
        }

        // If the cooldown is active, update the image
        background.enabled = true;
        imageCooldown.enabled = true;
        float cdTime = cooldown.GetCooldownProgress();

        imageCooldown.fillAmount = reverseFill ? 1 - cdTime : cdTime;

        // If the text is enabled, update the text
        if (ShowText)
        {
            int cooldownTime = cooldown.GetCooldownTime();

            if (cooldownTime == 0)
                cooldownTime = 1;

            textCooldown.SetText(cooldownTime.ToString());
        }

    }

    // Hides and cleans the text
    private void CleanImage()
    {
        imageCooldown.fillAmount = reverseFill ? 1 : 0;
        imageCooldown.enabled = false;
        background.enabled = false;
        textCooldown.SetText("");
    }

}