using UnityEngine;

public class DrawLine : MonoBehaviour
{
    public Transform startObject; // Assign the object from which the line starts
    public Vector2 endPosition; // Set the target position
    public LineRenderer lineRenderer;

    void Start()
    {
        // Set line properties
        lineRenderer.startWidth = 0.1f;
        lineRenderer.endWidth = 0.1f;
        lineRenderer.positionCount = 2;
    }

    void Update()
    {
        if (startObject != null)
        {
            // Set positions dynamically
            lineRenderer.SetPosition(0, startObject.position);
            lineRenderer.SetPosition(1, endPosition);
        }
    }
}
