using UnityEngine;
using UnityEngine.UI;

public class PositionIndicator : MonoBehaviour
{
    public PlayerController playerController;
    [SerializeField] private Image target;
    public bool isDisabled = false;

    private void Update()
    {
        if (isDisabled) return;

        if (playerController.IsAiming() || (!playerController.IsThrowable()))
        {
            target.enabled = false;
        }
        else
        {
            target.enabled = true;
        }
    }

    public void SetDisabled(bool disabled)
    {
        isDisabled = disabled;
        if (isDisabled)
        {
            target.enabled = false;
        }
    }
}