using UnityEngine;
using System.Collections;
using UnityEngine.UI;

public abstract class PassiveSkill : MonoBehaviour
{
}
public abstract class ActiveSkill : MonoBehaviour
{
    public int maxCharges = 1;
    public float cooldownDuration = 30f;
    public int currentCharges;
    protected bool isCooldown;
    protected int championLevel;
    public int skillType; // 1 = Primary, 2 = Secondary
    public Button currentButton = null;
    protected virtual void Start()
    {
        currentCharges = maxCharges;
    }

    private void FindButton()
    {
        if (currentButton != null) return;
        // Get all SkillButton components in the scene
        SkillButton[] skillButton = FindObjectsOfType<SkillButton>();
        Debug.Log(skillButton.Length);
        foreach (SkillButton button in skillButton)
        {
            Debug.Log(button.GetSkillType());
            Debug.Log(skillType);
            if (button.GetSkillType() == skillType)
            {
                SetButton(button.targetButton);
            }
        }
    }

    public void SetButton(Button button)
    {
        currentButton = button;
    }
    public void SetChampionLevel(int level)
    {
        championLevel = level;
    }

    public void TriggerSkill()
    {
        FindButton();
        if (currentCharges > 0 && !isCooldown)
        {
            currentCharges--;
            Activate();
            if (currentCharges <= 0) StartCoroutine(Cooldown());
        }
    }

    protected abstract void Activate();

    private IEnumerator Cooldown()
    {
        Debug.Log("Skill Cooldown Started");
        isCooldown = true;
        if (currentButton != null) currentButton.interactable = false;
        yield return new WaitForSeconds(cooldownDuration);
        currentCharges = maxCharges;
        isCooldown = false;
        if (currentButton != null) currentButton.interactable = true;
        Debug.Log("Skill Ready");
    }
}