using UnityEngine;
using System.Collections;

public class FeatherfallImpact : ActiveSkill
{
    private float duration = 3f;
    private float reduction = 0.2f;
    Rigidbody2D rb;
    public PlayerController pController;
    private bool isReducingBounce = false;

    protected override void Start()
    {
        pController = FindObjectOfType<PlayerController>();
        if (pController != null)
        {
            pController.OnPlayerCollision += HandlePlayerCollision;
            rb = pController.GetRigidbody();
        }
        reduction = 0.35f + 0.01f * championLevel;
    }

    private void HandlePlayerCollision(Collision2D collision)
    {
        if (isReducingBounce)
        {
            Vector2 velocity = rb.linearVelocity;
            Debug.Log(velocity);
            velocity.y *= (1 - reduction);
            velocity.x *= (1 - reduction);
            rb.linearVelocity = velocity;
            Debug.Log(velocity);
        }
    }

    private void OnDestroy()
    {
        // Unsubscribe when the script is destroyed to avoid memory leaks
        if (pController != null)
        {
            pController.OnPlayerCollision -= HandlePlayerCollision;
        }
    }

    protected override void Activate()
    {
        isReducingBounce = true;
        StartCoroutine(ResetBounceAfterDuration());
    }

    private IEnumerator ResetBounceAfterDuration()
    {
        yield return new WaitForSeconds(duration);
        isReducingBounce = false;
    }
}
