using UnityEngine;
public class ParPressurePlumage : PassiveSkill
{
    private Manager_Score scoreManager;
    public bool isTriggered = false;

    public void Start()
    {
        scoreManager = FindObjectOfType<Manager_Score>();
        scoreManager.OnStrokeChanged += TryTriggeringPassive;
    }

    // Each time the score changes check if the passive should be triggered
    public void TryTriggeringPassive(bool isTriggered)
    {
        this.isTriggered = isTriggered;
        if (isTriggered)
        {
            DoubleCaptureRange();
        }
        else
        {
            NormalCaptureRange();
        }
    }

    // Double the capture range
    private void DoubleCaptureRange()
    {
        GameSetters[] gameSetters = FindObjectsOfType<GameSetters>();
        foreach (GameSetters setter in gameSetters)
        {
            setter.SetThreshold(setter.GetThreshold() * 2.5f);
        }
    }

    // Reset the capture range back to normal
    private void NormalCaptureRange()
    {
        GameSetters[] gameSetters = FindObjectsOfType<GameSetters>();
        foreach (GameSetters setter in gameSetters)
        {
            setter.ResetThreshold();
        }
    }
}