using UnityEngine;
using UnityEngine.UI;

public class SkillButton : MonoBehaviour
{
    public Button targetButton; // Reference to the UI Button
    public GameObject targetObject; // The GameObject to activate/deactivate
    public float holdTimeThreshold = 0.5f; // Time required to hold before activation
    private Manager_Champion championManager;
    private float holdTimer = 0f;
    private bool isHolding = false;
    private bool hasActivated = false;
    public int buttonSkillType; // 0 basic, 1 primary, 2 secondary

    void Start()
    {
        championManager = FindObjectOfType<Manager_Champion>();
        if (targetButton != null)
        {
            targetButton.onClick.AddListener(OnButtonClicked); // Listen for button clicks
        }
    }

    public int GetSkillType()
    {
        return buttonSkillType;
    }

    void Update()
    {
        if (isHolding)
        {
            holdTimer += Time.deltaTime;

            if (holdTimer >= holdTimeThreshold && !hasActivated)
            {
                targetObject.SetActive(true); // Activate object if held long enough
                hasActivated = true;
            }
        }
    }

    public void OnPointerDown() // Called when button is pressed
    {
        isHolding = true;
        holdTimer = 0f;
        hasActivated = false;
    }

    public void OnPointerUp() // Called when button is released
    {
        if (hasActivated)
        {
            targetObject.SetActive(false); // Deactivate if it was activated
        }

        isHolding = false;
    }

    private void OnButtonClicked()
    {
        if (holdTimer < holdTimeThreshold) // If it was a quick tap, trigger the function
        {
            Trigger();
        }
    }

    void Trigger()
    {
        // Add your trigger logic here
        switch (buttonSkillType)
        {
            case 0:
                Debug.Log("Basic skill triggered!");
                break;
            case 1:
                championManager.TriggerPrimary();
                break;
            case 2:
                championManager.TriggerSecondary();
                break;
            default:
                Debug.LogWarning("Invalid skill type!");
                break;
        }
    }
}
