using UnityEngine;

public class Flipper : MonoBehaviour
{
  public Transform target;
  // "Flip the object" uisng scale -1 when the target is on the left side and the current object is on the right side
  
  void Start()
  {
    target = GameObject.Find("Player").GetComponent<Transform>();
  }

  public void Flip()
  {
    if (target.position.x < transform.position.x)
    {
        // Flip the object by rotating 180 degrees on the Y-axis
        transform.rotation = Quaternion.Euler(0, 180, 0);
    }
    else
    {
        // Ensure the object faces the default direction (not disappear)
        transform.rotation = Quaternion.Euler(0, 0, 0);
    }
  }

  private void Update()
  {
    // Example usage
    // Flip the object based on the position of the target object
    Flip();
  }
}