using UnityEngine;
using System.Collections;

public class Manager_Champion : MonoBehaviour
{
  [SerializeField] private RunHit runHit;
  [SerializeField] private ParChampion parChampion;
  private bool hitStopActivated = false;

  // Move the player to the ball
  public IEnumerator MoveToBall(bool hitStop)
  {
    hitStopActivated = hitStop;
    yield return StartCoroutine(Impact());
  }

  // Coroutine to move the player to the ball and wait for the impact
  IEnumerator Impact()
  {
    runHit.SetMove(true);

    // Wait until the object reaches the target
    while (Vector3.Distance(runHit.transform.localPosition, Vector3.zero) > 0.05f)
    {
      /* Debug.Log(Vector3.Distance(runHit.transform.localPosition, Vector3.zero)); */
        yield return null; // Waits for the next frame
    }

    runHit.SetMove(false);
    if (hitStopActivated)
    {
        StartCoroutine("Hitstop", 0.1f); // Apply hitstop for 0.1 seconds
    }
  }

  // Coroutine to apply hitstop effect
  private IEnumerator Hitstop(float duration)
  {
    Debug.Log("Hitstop activated for " + duration + " seconds");
    float originalTimeScale = Time.timeScale;
    Time.timeScale = 0f; // Pause time
    yield return new WaitForSecondsRealtime(duration); // Wait in real-time
    Time.timeScale = originalTimeScale; // Restore time
  }

  // Trigger par champion's activeskill
  public void TriggerPrimary()
  {
    /* Debug.Log("Primary skill triggered!"); */
    parChampion.UsePrimarySkill();
  }

  // Trigger par champion's activeskill
  public void TriggerSecondary()
  {
    /* Debug.Log("Secondary skill triggered!"); */
    parChampion.UseSecondarySkill();
  }
}