using UnityEngine;

public abstract class ParChampion : MonoBehaviour
{
    [SerializeField] private int championID;
    [SerializeField] private string championName;
    [SerializeField] private string championDescription;
    [SerializeField] private Sprite championIcon;
    [SerializeField] protected int championLevel;
    private int MAX_LEVEL = 30;

    public int ChampionID { get => championID; }
    public string ChampionName { get => championName; }
    public string ChampionDescription { get => championDescription; }
    public Sprite ChampionIcon { get => championIcon; }
    public int ChampionLevel { get => championLevel; }
    
    // Set the champion level, but ensure it is within the bounds of 1 and MAX_LEVEL
    public void SetChampionLevel(int level)
    {
        if (level > MAX_LEVEL)
        {
            championLevel = MAX_LEVEL;
        }
        else if (level < 1)
        {
            championLevel = 1;
        }
        else
        {
            championLevel = level;
        }
    }
    public abstract void UsePrimarySkill();
    public abstract void UseSecondarySkill();
    public abstract void TriggerPassiveSkill();
}