using UnityEngine;
using System.Collections;

public class RunHit : MonoBehaviour
{
    public bool move = false;
    private float speed = 0f; // Speed to move to the hit point
    private Vector3 targetPosition = Vector3.zero; // Fixed target position
    private bool applyHitstop = false; // Flag to apply hitstop

    // Set the target position to the hit point
    public void SetHitStop(bool state)
    {
        applyHitstop = state;
    }

    // Calculate speed once when movement is triggered
    public void StartMove()
    {
        float distance = Vector3.Distance(transform.localPosition, targetPosition);

        if (distance < 0.01f)
        {
            move = false;
            return;
        }

        // Calculate speed: the further the object, the faster it moves
        // Adjusted scaling to make it slightly slower and consistent
        speed = Mathf.Clamp(distance * 0.05f, 2f, 10f); // Adjusted min & max speed
        move = true; // Enable movement
    }

    // Smooth movement to the target (hitPoint) based on distance
    private void MoveToHitPoint()
    {
        if (!move) return;

        float distance = Vector3.Distance(transform.localPosition, targetPosition);

        if (distance < 0.1f) // Stop moving when close enough
        {
            transform.localPosition = targetPosition; // Snap to position
            move = false;
            return;
        }

        // Move the object based on the scaled speed, using Time.deltaTime for consistency
        transform.localPosition = Vector3.MoveTowards(transform.localPosition, targetPosition, speed * Time.deltaTime * 100f);
    }

    // Set the move state
    public void SetMove(bool state)
    {
        move = state;
        if (state) StartMove(); // Ensure speed is calculated before moving
    }

    // Update is called once per frame
    private void Update()
    {
        if (move)
        {
            MoveToHitPoint();
        }
    }
}
