using UnityEngine;
using UnityEngine.Purchasing;
using UnityEngine.UI;
using System.Collections.Generic;

public class IAP_Listener : MonoBehaviour, IStoreListener
{
    // Create a dictionary to store product ID -> product price
    Dictionary<string, string> productPrices = new Dictionary<string, string>();
    private static IStoreController storeController;
    private static IExtensionProvider storeExtensionProvider;
    [SerializeField] private Warning warning;

    void Start()
    {
        if (storeController == null)
        {
            InitializePurchasing();
        }
    }
    public void OnPurchaseButtonClicked(string productId)
    {
        if (storeController != null && storeController.products.WithID(productId) != null)
        {
            storeController.InitiatePurchase(productId);
        }
        else
        {
            Debug.LogError($"Product {productId} not found.");
            if (warning != null)
            {
                warning.ShowWarning($"Product {productId} not found.");
            }
        }
    }

    public void InitializePurchasing()
    {
        var builder = ConfigurationBuilder.Instance(StandardPurchasingModule.Instance());

        builder.AddProduct("skin_6_toilet_paper", ProductType.Consumable);

        UnityPurchasing.Initialize(this, builder);

        // Add products to the builder
    }

    public void OnInitialized(IStoreController controller, IExtensionProvider extensions)
    {
        storeController = controller;
        storeExtensionProvider = extensions;

        // Populate the dictionary
        foreach (Product product in controller.products.all)
        {
            string productId = product.definition.id;
            string productPrice = product.metadata.localizedPriceString;
            productPrices[productId] = productPrice;

            Debug.Log($"Product ID: {productId}, Price: {productPrice}");
        }
    }

    public void OnInitializeFailed(InitializationFailureReason error)
    {
        Debug.LogError($"Initialization Failed: {error}");
    }

    public void OnInitializeFailed(InitializationFailureReason error, string errorMessage)
    {
        Debug.LogError($"Initialization Failed: {error}, Message: {errorMessage}");
        if (warning != null)
        {
            warning.ShowWarning($"Initialization Failed: {errorMessage}");
        }
    }

    public PurchaseProcessingResult ProcessPurchase(PurchaseEventArgs args)
    {
        var product = args.purchasedProduct;

        if (product.definition.id == "skin_6_toilet_paper")
        {
            // Handle the purchase of the toilet paper skin
            Debug.Log("Toilet Paper Skin Purchased!");
            // Add your logic to unlock the skin here
            warning.ShowSuccess("Toilet Paper Skin Purchased!");
        }
        else
        {
            Debug.LogError($"Unknown product: {product.definition.id}");
            if (warning != null)
            {
                warning.ShowWarning($"Unknown product: {product.definition.id}");
            }
        }

        return PurchaseProcessingResult.Complete;
    }

    public void OnPurchaseFailed(Product product, PurchaseFailureReason reason)
    {
        Debug.LogError($"Purchase Failed: {product.definition.id}, Reason: {reason}");
        if (warning != null)
        {
            warning.ShowWarning($"Purchase Failed: {reason}");
        }
    }
}
