using UnityEngine;
using UnityEngine.UI;

public class IconPreparation : MonoBehaviour
{
    public Image trailIcon;
    public Image skinIcon;
    [SerializeField] Scriptable_ShopItemData shopItemData = null;

    private void Start()
    {
        UpdateIcons();
    }

    public void UpdateIcons()
    {
      if (PlayerPrefs.HasKey("BallSkin"))
      {
        SetSkinIcon(shopItemData.GetBallSkin(PlayerPrefs.GetInt("BallSkin")));
      }
      else
      {
        SetSkinIcon(shopItemData.GetBallSkin(0));
      }
    
      if (PlayerPrefs.HasKey("TrailEffect"))
      {
        SetTrailIcon(shopItemData.GetTrailEffect(PlayerPrefs.GetInt("TrailEffect")));
      }
      else
      {
        SetTrailIcon(shopItemData.GetTrailEffect(1000));
      }
    }

    public void SetTrailIcon(Color color)
    {
       trailIcon.color = color;
    }

    public void SetSkinIcon(Sprite icon)
    {
        skinIcon.sprite = icon;
    }

}