using UnityEngine;

public class Manager_Equip : MonoBehaviour
{
  public enum EquipType
  {
    BallSkin,
    TrailEffect
  }

  [SerializeField] private PlayerEquipment pEquipment;

  public bool isPreparationMenu = false;

  public void Awake()
  {
    pEquipment.LoadPurchasedItems();
    pEquipment.LoadEquippedItems();
  }

  public bool GetIsPreparationMenu()
  {
    return isPreparationMenu;
  }

  public void SaveItemPurchase(EquipType equipType, int itemID)
  {
    // Save the item purchase
    pEquipment.SaveItemPurchase(equipType, itemID);
  }

  public bool IsItemPurchased(EquipType equipType, int itemID)
  {
    // Check if the item is purchased
    return pEquipment.IsItemPurchased(equipType, itemID);
  }

  public void EquipItem(EquipType equipType, int itemID)
  {
    Debug.Log("Equipping item: " + itemID + " for " + equipType);
    // Equip the item
    pEquipment.EquipItem(equipType, itemID);
  }





}