using UnityEngine;
using TMPro;

public class Manager_Shop : MonoBehaviour
{
  [SerializeField] private Manager_Equip equipManager = null;
  [SerializeField] private PlayerCurrency playerCurrency = null;
  [SerializeField] private Warning warning = null;
  [SerializeField] private TextMeshProUGUI currencyCoin = null; // TODO refactor this to a UI manager

  public void Start()
  {
    playerCurrency.LoadCurrency();
    currencyCoin.text = playerCurrency.GetCurrency(ShopKeys.CUR_TYPE_COIN).ToString();
  }

  public bool BuyItem(Manager_Equip.EquipType equipType, int itemID, string currencyType, int cost)
  {
    Debug.Log("Buying item: " + itemID + " for " + cost + " " + currencyType);
    bool isItemPurchased = false;
    int currency = playerCurrency.GetCurrency(currencyType);

    // Check if the player has enough currency to buy the item
    if (currency >= cost)
    {
      playerCurrency.RemoveCurrency(currencyType, cost);
      playerCurrency.SaveCurrency();
      equipManager.SaveItemPurchase(equipType, itemID);
      isItemPurchased = true;
      warning.ShowWarning("Item purchased", Warning.WarningType.Positive);
    }
    else
    {
      warning.ShowWarning("Not enough currency to buy this item", Warning.WarningType.Negative);
    }

    UpdateCurrency();

    return isItemPurchased;
  }

  public bool HasEnoughCurrency(string currencyType, int cost)
  {
    int currency = playerCurrency.GetCurrency(currencyType);
    return currency >= cost;
  }

  // TODO make the UI of the shop items build dynamically so I don't have to hardcode the items
  public void UpdateCurrency()
  {
    currencyCoin.text = playerCurrency.GetCurrency(ShopKeys.CUR_TYPE_COIN).ToString();
  }

}