using UnityEngine;
using UnityEngine.UI;
using TMPro;
using System.Collections.Generic;

public class Object_ItemInteractor : MonoBehaviour
{
  [SerializeField] private Manager_Equip.EquipType equipType;
  [SerializeField] private Manager_Shop shopManager = null;
  [SerializeField] private Manager_Equip equipManager = null;
  [SerializeField] private Purchase_Popup purPop = null;
  public string itemName = "Default";
  public int itemID = 0;
  public string currencyType = ShopKeys.CUR_TYPE_COIN;
  public int cost = 999999;
  public bool isPurchased = false;
  public Button buyButton;
  public Button equipButton;

  public GameObject selectedItemFrame;
  public GameObject equippedItemFrame;
  public TextMeshProUGUI equipText;

  public bool isPreparationMenu = false;
  public bool isPremiumItem = false;

  // Needs refactor -> very ugly and fast implementation
  public void Start()
  {
    equipManager = FindAnyObjectByType<Manager_Equip>();
    if (equipManager == null)
    {
      Debug.LogError("Equip Manager not found in the scene");
    }
    isPreparationMenu = equipManager.GetIsPreparationMenu();

    shopManager = FindAnyObjectByType<Manager_Shop>();

    if (shopManager == null && !isPreparationMenu)
    {
      Debug.LogError("Shop Manager not found in the scene");
    }


    purPop = FindObjectOfType<Purchase_Popup>();
    if (purPop == null)
    {
      Debug.LogError("Purchase Popup not found in the scene");
    }

    UpdateItemState();

    if (equipType == Manager_Equip.EquipType.BallSkin)
    {
      if (PlayerPrefs.HasKey("BallSkin"))
      {
        SetEquippedItem(PlayerPrefs.GetInt("BallSkin"));
      }
      else
      {
        PlayerPrefs.SetInt("BallSkin", 0);
      }
    }
    else if (equipType == Manager_Equip.EquipType.TrailEffect)
    {
      if (PlayerPrefs.HasKey("TrailEffect"))
      {
        SetEquippedItem(PlayerPrefs.GetInt("TrailEffect"));
      }
      else
      {
        PlayerPrefs.SetInt("TrailEffect", 1000);
      }
    }

    if (!isPremiumItem)
    {
      buyButton.onClick.AddListener(ShowPopUp);
    }

  }

  public void TryBuyItem()
  {
    if(shopManager.BuyItem(equipType, itemID, currencyType, cost))
    {
      UpdateItemState();
    }
  }

  public void PremiumBuyItem()
  {
    if (!isPremiumItem) return;
    equipManager.SaveItemPurchase(equipType, itemID);            
    SetEquippedItem(itemID);
    UpdateItemState();
    EquipItem();
  }
  public void EquipItem()
  {
    if (isPurchased)
    {
      equipManager.EquipItem(equipType, itemID);
      SetEquippedItem(itemID);
    }
  }

  // Select an item
  public void SelectItem()
  {
    if (isPreparationMenu) return;
    equipManager.EquipItem(equipType, itemID);
    SetSelectedItem(itemID);
  }

  // Ensure that the selected item is the only one selected
  private void SetSelectedItem(int itemID)
  {
    Object_ItemInteractor[] allItems = FindObjectsOfType<Object_ItemInteractor>();
    foreach (Object_ItemInteractor item in allItems)
    {
      if (item.itemID == itemID)
      {
        item.SetSelectedItem(true);
      }
      else
      {
        item.SetSelectedItem(false);
      }
    }
  }

  // Ensure that the equipped item is the only one equipped
  public void SetEquippedItem(int itemID)
  {
    Debug.Log("Setting equipped item: " + itemID);
    Object_ItemInteractor[] allItems = FindObjectsOfType<Object_ItemInteractor>();
    foreach (Object_ItemInteractor item in allItems)
    {
      if (item.itemID == itemID)
      {
        Debug.Log("In: " + itemID);
        item.equipText.text = "Equipped";
        item.equipButton.interactable = false;
        item.SetEquippedItem(true);
        item.SetSelectedItem(false);
        if (item.equipType == Manager_Equip.EquipType.BallSkin)
        {
          PlayerPrefs.SetInt("BallSkin", itemID);
        }
        else if (item.equipType == Manager_Equip.EquipType.TrailEffect)
        {
          PlayerPrefs.SetInt("TrailEffect", itemID);
        }
      }
      else
      {
        item.equipText.text = "Equip";
        item.equipButton.interactable = true;
        item.SetEquippedItem(false);
      }
    }
  }

  // Show the purchase popup
  private void ShowPopUp()
  {
    if (shopManager.HasEnoughCurrency(currencyType, cost))
    {
      purPop.ShowPurchasePopup(gameObject.GetComponent<Object_ItemInteractor>());
    }
    else
    {
      // TODO show warning
      Debug.Log("Not enough currency to buy this item");
    }
  }

  // Obtains the item by ID
  public int GetItemID()
  {
    return itemID;
  }

  // Show the selected item frame
  public void SetSelectedItem(bool isSelected)
  {
    selectedItemFrame.SetActive(isSelected);
  }

  // show the equipped item frame
  public void SetEquippedItem(bool isEquipped)
  {
    equippedItemFrame.SetActive(isEquipped);
  }

  // Update the item state
  public void UpdateItemState()
  {
    isPurchased = equipManager.IsItemPurchased(equipType, itemID);

    if (!isPurchased && isPreparationMenu)
    {
      Destroy(gameObject); // Destroy the item if it's in the preparation menu
    }

    if (isPurchased)
    {
      buyButton.gameObject.SetActive(false);
      equipButton.gameObject.SetActive(true);
    }
    else
    {
      buyButton.gameObject.SetActive(true);
      equipButton.gameObject.SetActive(false);
    }
  }

}