using UnityEngine;
using System.Collections.Generic;

public class PlayerCurrency : MonoBehaviour
{
    private Dictionary<string, int> currency = new Dictionary<string, int>
    {
        { ShopKeys.CUR_TYPE_COIN, 0 },
        { ShopKeys.CUR_TYPE_DIAMOND, 0 }
    };

    private string KEY = "CurrencyData"; // temp key

    public void AddCurrency(string type, int amount)
    {
        if (currency.ContainsKey(type))
            currency[type] += amount;
    }

    public void RemoveCurrency(string type, int amount)
    {
        if (currency.ContainsKey(type))
            currency[type] = Mathf.Max(0, currency[type] - amount);
    }

    public int GetCurrency(string type)
    {
        return currency.ContainsKey(type) ? currency[type] : 0;
    }

    public void SetCurrency(string type, int amount)
    {
        if (currency.ContainsKey(type))
            currency[type] = amount;
    }

    public bool CanAfford(string type, int amount)
    {
        return currency.ContainsKey(type) && currency[type] >= amount;
    }

    // Use Easy Save 3 to save the currency
    public void SaveCurrency()
    {
      ES3.Save(KEY, currency, ShopKeys.GetCurrencyPath());
    }

    public void LoadCurrency()
    {
      if (ES3.FileExists(ShopKeys.GetCurrencyPath()))
      {
          currency = ES3.Load<Dictionary<string, int>>(KEY, ShopKeys.GetCurrencyPath());
      }
      else
      {
          currency = new Dictionary<string, int>
          {
              { ShopKeys.CUR_TYPE_COIN, 999999 },
              { ShopKeys.CUR_TYPE_DIAMOND, 0 }
          };
      }
      SaveCurrency();
    }

}
