using UnityEngine;
using TMPro;

public class Purchase_Popup : MonoBehaviour
{
    [SerializeField] private Object_ItemInteractor itemInteractor;
    [SerializeField] private GameObject purchasePopup;
    [SerializeField] private TextMeshProUGUI itemNameText;

    public void ShowPurchasePopup(Object_ItemInteractor itemInteractor)
    {
        this.itemInteractor = itemInteractor;
        itemNameText.text = "Are you sure you want to spend " + itemInteractor.cost + " " + itemInteractor.currencyType + " to buy " + itemInteractor.itemName + "?";

        purchasePopup.SetActive(true);
    }

    public void HidePurchasePopup()
    {
        purchasePopup.SetActive(false);
    }

    public void PurchaseItem()
    {
        if (itemInteractor != null)
        {
            itemInteractor.TryBuyItem();
            HidePurchasePopup();
        }
        else
        {
            Debug.LogError("Item Interactor is null");
        }
    }

}