using UnityEngine;

[CreateAssetMenu(fileName = "ShopItemData", menuName = "ScriptableObjects/ShopItemData")]
public class Scriptable_ShopItemData : ScriptableObject
{
    public Sprite[] ballSkins;
    public Color[] trailColors;
    
    // Get the ball skin sprite
    public Sprite GetBallSkin(int skinID)
    {
        if (ballSkins == null || ballSkins.Length == 0)
        {
            Debug.LogWarning("BallSkins array is empty or null!");
            return null;
        }
        
        skinID = Mathf.Clamp(skinID, 0, ballSkins.Length - 1);
        return ballSkins[skinID];
    }

    // Get the trail color
    public Color GetTrailEffect(int colorID)
    {
        int realID = colorID - 1000;
        if (trailColors == null || trailColors.Length == 0)
        {
            Debug.LogWarning("TrailColors array is empty or null!");
            return Color.white; // Default fallback color
        }

        realID = Mathf.Clamp(realID, 0, trailColors.Length - 1);
        return trailColors[realID];
    }

}
