using UnityEngine;
using UnityEngine.Tilemaps;
using System.Collections.Generic;
using System.Collections;

public class TileDetector : MonoBehaviour
{
    public Tilemap floorTile;
    public Tilemap terrainTile;
    private float checkRadius = 0.2f; // radius around the center to check (adjust as needed)
    [SerializeField] private Manager_Player playerManager;

    private bool deadTriggered = false;
    private void Awake()
    {
        floorTile = GameObject.FindGameObjectWithTag("FloorTile").GetComponent<Tilemap>();
        terrainTile = GameObject.FindGameObjectWithTag("TerrainTile").GetComponent<Tilemap>();
    }

    void Update()
    {   
        // Check if the player is dead
        if (deadTriggered)
            return;
        

        Vector3 center = transform.position;
        bool onTile = false;

        // Directions to sample around the player (8 directions + center)
        Vector3[] offsets = {
            Vector3.zero,
            Vector3.right * checkRadius,
            Vector3.left * checkRadius,
            Vector3.up * checkRadius,
            Vector3.down * checkRadius,
            (Vector3.right + Vector3.up).normalized * checkRadius,
            (Vector3.right + Vector3.down).normalized * checkRadius,
            (Vector3.left + Vector3.up).normalized * checkRadius,
            (Vector3.left + Vector3.down).normalized * checkRadius
        };

        foreach (var offset in offsets)
        {
            Vector3 checkPos = center + offset;
            Vector3Int cell_fl = floorTile.WorldToCell(checkPos);
            Vector3Int cell_tr = terrainTile.WorldToCell(checkPos);

            if (floorTile.GetTile(cell_fl) != null || terrainTile.GetTile(cell_tr) != null)
            {
                onTile = true;
                break; // Exit early if we find any tile
            }
        }

        if (onTile)
        {
           // Apply effect or something when on tile
        }
        else
        {
            // Here the player has died, return to the last position or spawn
            deadTriggered = true;
            StartCoroutine(ResetLevelCoroutine());
        }
    }

    // "die effect" and appear
    private IEnumerator ResetLevelCoroutine()
    {
        yield return new WaitForSeconds(0.05f);
        playerManager.StopPlayerAndDie();

        yield return new WaitForSeconds(0.2f);
        playerManager.ReturnToLastValidPosition();
        playerManager.MakePlayerAppear(true, true);
        deadTriggered = false; // Reset the deadTriggered flag
    }

}
