using UnityEngine;
using TMPro;

// This class is holds the basic information of a local map prefab
public class Object_MapDisplay : MonoBehaviour
{
    [SerializeField] private TextMeshProUGUI mapNameText;
    [SerializeField] private TextMeshProUGUI mapDate;

    private Manager_MapDataLocal mapHolder;
    MapData_ES3 mapData;

    public GameObject verifiedIndicator;
    public GameObject unverifiedIndicator;

    public GameObject sharedIndicator;
    public GameObject unsharedIndicator;

    public void Awake()
    {
        GameObject managers = GameObject.FindWithTag("Manager_Local");
        mapHolder = managers.GetComponent<Manager_MapDataLocal>();
    }

    // Using MapHolder to show the map edit menu
    public void OpenMapInteractionMenu()
    {
        mapHolder.PopoulateInteractionMenu(mapData);
    }

    // Set the map data
    public void SetMapData(MapData_ES3 mapData)
    {   
        this.mapData = mapData;
        mapNameText.text = mapData.name;
        mapDate.text =  mapData.lastModifiedDate;

        // Set the indicators based on map data
        verifiedIndicator.SetActive(mapData.isValidated);
        unverifiedIndicator.SetActive(!mapData.isValidated);

        sharedIndicator.SetActive(mapData.isUploaded);
        unsharedIndicator.SetActive(!mapData.isUploaded);
    }
}